/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.http;

import com.sendgrid.http.HttpMethod;
import com.sendgrid.util.Utility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request {
    private final HttpMethod method;
    private final String endPoint;
    private final String domain;
    private String body;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private Map<String, String> pathParams = new HashMap<String, String>();
    private String region;
    private List<String> userAgentExtensions;
    private String url;

    public Request(HttpMethod method, String endPoint, String domain) {
        this.method = method;
        this.endPoint = endPoint;
        this.domain = domain;
    }

    public void addPathParam(String key, String value) {
        this.pathParams.put(key, value);
    }

    public void addHeaderParam(String key, String value) {
        this.headers.put(key, value);
    }

    public void addQueryParam(String key, String value) {
        this.queryParams.put(key, value);
    }

    public void addBody(String body) {
        this.body = body;
    }

    public void buildUrl() {
        String baseUrl = Utility.buildBaseUrl(this.domain, this.region, this.endPoint);
        baseUrl = Utility.buildWithPathParams(baseUrl, this.pathParams);
        this.url = baseUrl = Utility.buildWithQueryParams(baseUrl, this.queryParams);
    }

    public void buildUrl(String url) {
        this.url = url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<String> getUserAgentExtensions() {
        return this.userAgentExtensions;
    }

    public void setUserAgentExtensions(List<String> userAgentExtensions) {
        this.userAgentExtensions = userAgentExtensions;
    }

    public String getUrl() {
        return this.url;
    }
}

