/*
 * Decompiled with CFR 0.152.
 */
package com.semanticcms.dia.servlet.impl;

import com.aoapps.concurrent.KeyedConcurrencyReducer;
import com.aoapps.hodgepodge.awt.image.ImageSizeCache;
import com.aoapps.html.any.AnyA;
import com.aoapps.html.any.AnyIMG;
import com.aoapps.html.any.AnyPhrasingContent;
import com.aoapps.html.any.DocumentMediaWriter;
import com.aoapps.lang.ProcessResult;
import com.aoapps.lang.concurrent.ExecutionExceptions;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.lang.util.Sequence;
import com.aoapps.lang.util.UnsynchronizedSequence;
import com.aoapps.net.URIEncoder;
import com.aoapps.servlet.attribute.ScopeEE;
import com.aoapps.servlet.lastmodified.LastModifiedServlet;
import com.semanticcms.core.model.Page;
import com.semanticcms.core.model.PageRef;
import com.semanticcms.core.servlet.CaptureLevel;
import com.semanticcms.core.servlet.ConcurrencyCoordinator;
import com.semanticcms.core.servlet.PageIndex;
import com.semanticcms.core.servlet.PageRefResolver;
import com.semanticcms.dia.model.Dia;
import com.semanticcms.dia.servlet.impl.DiaExport;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class DiaImpl {
    private static final String LINUX_DIA_PATH = "/usr/bin/dia";
    private static final String WINDOWS_DIA_PATH = "C:\\Program Files (x86)\\Dia\\bin\\dia.exe";
    private static final TempDirLock tempDirLock = new TempDirLock();
    private static final String TEMP_SUBDIR = DiaExport.class.getName();
    private static final String MISSING_IMAGE_PATH = "/semanticcms-dia-servlet/images/broken-chain-1164481-640x480.jpg";
    private static final int MISSING_IMAGE_WIDTH = 640;
    private static final int MISSING_IMAGE_HEIGHT = 480;
    public static final char SIZE_SEPARATOR = '-';
    public static final char EMPTY_SIZE = '_';
    public static final char DIMENSION_SEPARATOR = 'x';
    public static final String PNG_EXTENSION = ".png";
    private static final ScopeEE.Request.Attribute<Sequence> ID_SEQUENCE_REQUEST_ATTRIBUTE = ScopeEE.REQUEST.attribute(DiaImpl.class.getName() + ".idSequence");
    private static final String ALT_LINK_ID_PREFIX = "semanticcms-dia-servlet-alt-pixel-ratio-";
    private static final int DEFAULT_WIDTH = 200;
    private static final int[] PIXEL_DENSITIES = new int[]{1, 2, 3, 4};
    private static final KeyedConcurrencyReducer<File, Void> exportConcurrencyLimiter = new KeyedConcurrencyReducer();

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase(Locale.ROOT).contains("windows");
    }

    private static String getDiaExportPath() {
        if (DiaImpl.isWindows()) {
            return WINDOWS_DIA_PATH;
        }
        return LINUX_DIA_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiaExport exportDiagram(PageRef pageRef, Integer width, Integer height, File tmpDir) throws InterruptedException, FileNotFoundException, IOException {
        File tmpFile;
        File diaFile = pageRef.getResourceFile(true, true);
        String diaPath = pageRef.getPath();
        if (diaPath.toLowerCase(Locale.ROOT).endsWith(".dia")) {
            diaPath = diaPath.substring(0, diaPath.length() - ".dia".length());
        }
        TempDirLock tempDirLock = DiaImpl.tempDirLock;
        synchronized (tempDirLock) {
            tmpFile = new File(tmpDir, TEMP_SUBDIR + pageRef.getBookPrefix().replace('/', File.separatorChar) + diaPath.replace('/', File.separatorChar) + "-" + (width == null ? "_" : width.toString()) + "x" + (height == null ? "_" : height.toString()) + PNG_EXTENSION);
            tmpDir = tmpFile.getParentFile();
            if (!tmpDir.exists()) {
                Files.createDirectories(tmpDir.toPath(), new FileAttribute[0]);
            }
        }
        try {
            exportConcurrencyLimiter.executeSerialized((Object)tmpFile, () -> {
                if (!tmpFile.exists() || diaFile.lastModified() >= tmpFile.lastModified()) {
                    String sizeParam = width == null ? (height == null ? null : "x" + height) : (height == null ? width + "x" : width + "x" + height);
                    String diaExePath = DiaImpl.getDiaExportPath();
                    String[] command = sizeParam == null ? new String[]{diaExePath, "--export=" + tmpFile.getCanonicalPath(), "--filter=png", "--log-to-stderr", diaFile.getCanonicalPath()} : new String[]{diaExePath, "--export=" + tmpFile.getCanonicalPath(), "--filter=png", "--size=" + sizeParam, "--log-to-stderr", diaFile.getCanonicalPath()};
                    ProcessResult result = ProcessResult.exec((String[])command);
                    int exitVal = result.getExitVal();
                    if (exitVal != 0) {
                        throw new IOException(diaExePath + ": non-zero exit value: " + exitVal);
                    }
                    if (!DiaImpl.isWindows()) {
                        String normalOutput = diaFile.getCanonicalPath() + " --> " + tmpFile.getCanonicalPath();
                        boolean foundNormalOutput = false;
                        String stderr = result.getStderr();
                        try (BufferedReader errIn = new BufferedReader(new StringReader(stderr));){
                            String line;
                            while ((line = errIn.readLine()) != null) {
                                if (!line.equals(normalOutput)) continue;
                                foundNormalOutput = true;
                                break;
                            }
                        }
                        if (!foundNormalOutput) {
                            throw new IOException(diaExePath + ": " + stderr);
                        }
                    }
                }
                return null;
            });
        }
        catch (ExecutionException e) {
            ExecutionExceptions.wrapAndThrowWithTemplate((ExecutionException)e, FileNotFoundException.class, (template, cause) -> {
                FileNotFoundException fnf = new FileNotFoundException(template.getMessage());
                fnf.initCause((Throwable)cause);
                return fnf;
            });
            ExecutionExceptions.wrapAndThrow((ExecutionException)e, IOException.class, IOException::new);
            throw new WrappedException((Throwable)e);
        }
        Dimension pngSize = ImageSizeCache.getImageSize((File)tmpFile);
        return new DiaExport(tmpFile, pngSize.width, pngSize.height);
    }

    private static String buildUrlPath(HttpServletRequest request, PageRef pageRef, int width, int height, int pixelDensity, DiaExport export) throws ServletException {
        String diaPath = pageRef.getPath();
        if (!diaPath.endsWith(".dia")) {
            throw new ServletException("Unexpected file extension for diagram: " + diaPath);
        }
        diaPath = diaPath.substring(0, diaPath.length() - ".dia".length());
        StringBuilder urlPath = new StringBuilder();
        urlPath.append(request.getContextPath()).append("/semanticcms-dia-servlet/dia-export").append(pageRef.getBookPrefix()).append(diaPath).append('-');
        if (width == 0) {
            urlPath.append('_');
        } else {
            urlPath.append(width * pixelDensity);
        }
        urlPath.append('x');
        if (height == 0) {
            urlPath.append('_');
        } else {
            urlPath.append(height * pixelDensity);
        }
        urlPath.append(PNG_EXTENSION);
        if (!"false".equalsIgnoreCase(request.getHeader("X-com-aoapps-servlet-lastmodified-enabled"))) {
            urlPath.append('?').append("lastModified").append('=').append(LastModifiedServlet.encodeLastModified((long)export.getTmpFile().lastModified()));
        }
        return urlPath.toString();
    }

    public static void writeDiaImpl(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, AnyPhrasingContent<?, ?> content, Dia dia) throws ServletException, IOException {
        block21: {
            try {
                List exports;
                File resourceFile;
                CaptureLevel captureLevel = CaptureLevel.getCaptureLevel((ServletRequest)request);
                if (captureLevel.compareTo((Enum)CaptureLevel.META) < 0) break block21;
                PageRef pageRef = PageRefResolver.getPageRef((ServletContext)servletContext, (HttpServletRequest)request, (String)dia.getBook(), (String)dia.getPath());
                if (captureLevel != CaptureLevel.BODY) break block21;
                int width = dia.getWidth();
                int height = dia.getHeight();
                if (width == 0 && height == 0) {
                    width = 200;
                }
                if ((resourceFile = pageRef.getResourceFile(false, true)) == null) {
                    exports = null;
                } else {
                    File tempDir = (File)ScopeEE.Application.TEMPDIR.context(servletContext).get();
                    int finalWidth = width;
                    int finalHeight = height;
                    ArrayList<Callable<DiaExport>> tasks = new ArrayList<Callable<DiaExport>>(PIXEL_DENSITIES.length);
                    for (int i = 0; i < PIXEL_DENSITIES.length; ++i) {
                        int pixelDensity = PIXEL_DENSITIES[i];
                        tasks.add(() -> DiaImpl.exportDiagram(pageRef, finalWidth == 0 ? null : Integer.valueOf(finalWidth * pixelDensity), finalHeight == 0 ? null : Integer.valueOf(finalHeight * pixelDensity), tempDir));
                    }
                    try {
                        exports = ConcurrencyCoordinator.getRecommendedExecutor((ServletContext)servletContext, (ServletRequest)request).callAll(tasks);
                    }
                    catch (ExecutionException e) {
                        ExecutionExceptions.wrapAndThrow((ExecutionException)e, IOException.class, IOException::new);
                        throw new ServletException((Throwable)e);
                    }
                }
                DiaExport export = exports == null ? null : (DiaExport)exports.get(0);
                Sequence idSequence = (Sequence)ID_SEQUENCE_REQUEST_ATTRIBUTE.context((ServletRequest)request).computeIfAbsent(__ -> new UnsynchronizedSequence());
                String refId = PageIndex.getRefIdInPage((HttpServletRequest)request, (Page)dia.getPage(), (String)dia.getId());
                Object urlPath = export != null ? DiaImpl.buildUrlPath(request, pageRef, width, height, PIXEL_DENSITIES[0], export) : request.getContextPath() + MISSING_IMAGE_PATH;
                ((AnyIMG)((AnyIMG)((AnyIMG)((AnyIMG)((AnyIMG)content.img().id((Object)refId)).src(response.encodeURL(URIEncoder.encodeURI((String)urlPath)))).width(export != null ? export.getWidth() / PIXEL_DENSITIES[0] : (width != 0 ? width : 640 * height / 480))).height(export != null ? export.getHeight() / PIXEL_DENSITIES[0] : (height != 0 ? height : 480 * width / 640))).alt((Object)dia.getLabel())).__();
                if (export == null || PIXEL_DENSITIES.length <= 1) break block21;
                assert (resourceFile != null);
                assert (exports != null);
                long[] altLinkNums = new long[PIXEL_DENSITIES.length];
                for (int i = 0; i < PIXEL_DENSITIES.length; ++i) {
                    long altLinkNum;
                    int pixelDensity = PIXEL_DENSITIES[i];
                    DiaExport altExport = (DiaExport)exports.get(i);
                    altLinkNums[i] = altLinkNum = idSequence.getNextSequenceValue();
                    String altUrlPath = DiaImpl.buildUrlPath(request, pageRef, width, height, pixelDensity, altExport);
                    ((AnyA)((AnyA)((AnyA)content.a().id(id -> id.append((CharSequence)ALT_LINK_ID_PREFIX).append((CharSequence)Long.toString(altLinkNum)))).style((Object)"display:none")).href(response.encodeURL(URIEncoder.encodeURI((String)altUrlPath)))).__(a -> ((AnyPhrasingContent)a.text('x')).text((Object)pixelDensity));
                }
                try (DocumentMediaWriter script = content.script()._c();){
                    int i;
                    script.write("if(window.devicePixelRatio) {\n");
                    script.write("\t(function () {\n");
                    script.write("\t\tfunction updateImageSrc() {\n");
                    for (i = PIXEL_DENSITIES.length - 1; i >= 0; --i) {
                        long altLinkNum = altLinkNums[i];
                        script.write("\t\t\t");
                        if (i != PIXEL_DENSITIES.length - 1) {
                            script.write("else ");
                        }
                        if (i > 0) {
                            script.write("if(window.devicePixelRatio > ");
                            script.write(Integer.toString(PIXEL_DENSITIES[i - 1]));
                            script.write(") ");
                        }
                        script.append((CharSequence)"{\n\t\t\t\tdocument.getElementById(").text((CharSequence)refId).append((CharSequence)").src = document.getElementById(\"semanticcms-dia-servlet-alt-pixel-ratio-").append((CharSequence)Long.toString(altLinkNum)).append((CharSequence)"\").getAttribute(\"href\");\n\t\t\t}\n");
                    }
                    script.write("\t\t}\n\t\tupdateImageSrc();\n");
                    script.write("\t\tif(window.matchMedia) {\n");
                    for (i = 0; i < PIXEL_DENSITIES.length; ++i) {
                        int pixelDensity = PIXEL_DENSITIES[i];
                        script.write("\t\t\twindow.matchMedia(\"screen and (max-resolution: ");
                        script.write(Integer.toString(pixelDensity));
                        script.write("dppx)\").addListener(function(e) {\n\t\t\t\tupdateImageSrc();\n\t\t\t});\n");
                    }
                    script.write("\t\t}\n\t})();\n}");
                }
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private DiaImpl() {
    }

    private static class TempDirLock {
        private TempDirLock() {
        }
    }
}

