/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.json.core;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.unmarshaller.json.core.JsonParserUtils;
import com.sdl.odata.util.ReferenceUtil;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertyExpander {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPropertyExpander.class);
    private EntityDataModel entityDataModel;

    public JsonPropertyExpander(EntityDataModel entityDataModel) {
        this.entityDataModel = entityDataModel;
    }

    public void fillUpdatedObjectProperty(Object entity, Object currentNode, StructuralProperty property, Field field, String node, Map<String, Object> map) throws ODataException {
        for (Map.Entry<String, Object> entry : ((Map)currentNode).entrySet()) {
            if (this.findAppropriateElement(entity, property, field, node, map, entry)) break;
        }
    }

    private void fillEntryFeed(Object entity, Object currentNode, StructuralProperty property, Field field, String node, Map<String, Object> map) throws ODataException {
        Map entryMap = (Map)map.get(currentNode);
        for (Map.Entry<String, Object> entry : entryMap.entrySet()) {
            if (this.findAppropriateElement(entity, property, field, node, entryMap, entry)) break;
        }
    }

    private boolean findAppropriateElement(Object entity, StructuralProperty property, Field field, String node, Map<String, Object> map, Map.Entry<String, Object> entry) throws ODataException {
        if (node.equalsIgnoreCase(entry.getKey()) && entry.getValue() != null) {
            Object value = this.getFieldValueByType(property.getTypeName(), entry.getValue(), map, true);
            if (value != null) {
                JsonParserUtils.setFieldValue(field, entity, value);
                return true;
            }
            LOG.warn("There is no element with name '{}'", (Object)node);
        }
        return false;
    }

    public void fillUpdatedCollectionProperty(Object entity, Object currentNode, StructuralProperty property, Field field, String node, Map<String, Object> map) throws ODataException {
        AbstractCollection valueSet = field.getType().isAssignableFrom(Set.class) ? new HashSet() : new ArrayList();
        for (Object subValue : (Iterable)((Map)currentNode).get(node)) {
            Object value = this.getFieldValueByType(property.getElementTypeName(), subValue, map, true);
            if (value == null) continue;
            valueSet.add(value);
        }
        JsonParserUtils.setFieldValue(field, entity, valueSet);
    }

    public void fillPrimitiveProperty(Object entity, Set<String> keySet, StructuralProperty property, Field field, String node, Map<String, Object> map) throws ODataException {
        for (String target : keySet) {
            if (!node.equalsIgnoreCase(target)) continue;
            Object value = this.getFieldValueByType(property.getTypeName(), target, map, false);
            if (value != null) {
                JsonParserUtils.setFieldValue(field, entity, value);
                break;
            }
            LOG.warn("There is no element with name '{}'", (Object)node);
        }
    }

    public void fillCollectionProperty(Object entity, Set<String> keySet, StructuralProperty property, Field field, String node, Map<String, Object> map) throws ODataException {
        for (String target : keySet) {
            if (!node.equalsIgnoreCase(target)) continue;
            Iterable subValues = (Iterable)map.get(target);
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (Object subValue : subValues) {
                Object value = this.getFieldValueByType(property.getElementTypeName(), subValue, map, true);
                if (value == null) continue;
                valueList.add(value);
            }
            JsonParserUtils.setFieldValue(field, entity, valueList);
            break;
        }
    }

    protected Object getFieldValueByType(String typeName, Object targetNode, Map<String, Object> map, boolean isExtracted) throws ODataException {
        Object fieldValue = null;
        LOG.debug("Type is {}", (Object)typeName);
        Type type = this.entityDataModel.getType(typeName);
        if (type == null) {
            throw new ODataUnmarshallingException("OData type not found: " + typeName);
        }
        switch (type.getMetaType()) {
            case ENUM: 
            case PRIMITIVE: {
                if (isExtracted) {
                    fieldValue = JsonParserUtils.getAppropriateFieldValue(type.getJavaType(), String.valueOf(targetNode));
                    break;
                }
                if (map.get(targetNode) == null) break;
                fieldValue = JsonParserUtils.getAppropriateFieldValue(type.getJavaType(), String.valueOf(map.get(targetNode)));
                break;
            }
            case ENTITY: 
            case COMPLEX: {
                fieldValue = this.unmarshallEntityByName(typeName, map, targetNode);
                break;
            }
            default: {
                LOG.warn("Unsupported type {}.", (Object)type.getMetaType().name());
                throw new UnsupportedOperationException("Unsupported type: " + typeName);
            }
        }
        return fieldValue;
    }

    private Object unmarshallEntityByName(String entityName, Map<String, Object> map, Object currentNode) throws ODataException {
        LOG.debug("Entity '{}' created.", (Object)entityName);
        if (!ReferenceUtil.isNullOrEmpty((String)entityName)) {
            Object entity = this.loadEntity(entityName);
            this.setEntityProperties(entity, JsonParserUtils.getStructuredType(entityName, this.entityDataModel), map, currentNode);
            LOG.debug("Entity '{}' properties mapped successfully.", (Object)entityName);
            return entity;
        }
        throw new ODataUnmarshallingException("Unmarshalling Entity name should be null !!!!...");
    }

    public Object loadEntity(String entityName) throws ODataUnmarshallingException {
        Object entity = null;
        if (entityName != null) {
            try {
                StructuredType entityType = JsonParserUtils.getStructuredType(entityName, this.entityDataModel);
                if (entityType == null) {
                    LOG.warn("Given entity '{}' is not found in entity data model", (Object)entityName);
                    throw new ODataUnmarshallingException("Couldn't initiate entity because given entity [" + entityName + "] is not found in entity data model.");
                }
                entity = entityType.getJavaType().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ODataUnmarshallingException("Cannot instantiate entity", (Throwable)e);
            }
        }
        return entity;
    }

    public void setEntityProperties(Object entity, StructuredType entityType, Map<String, Object> map, Object currentNode) throws ODataException {
        Set<String> keySet = map.keySet();
        for (StructuralProperty property : JsonParserUtils.getAllProperties(entityType, this.entityDataModel)) {
            Field field = property.getJavaField();
            String node = property.getName();
            LOG.debug("Property Name is {}", (Object)node);
            if (property.isCollection()) {
                if (currentNode == null) {
                    this.fillCollectionProperty(entity, keySet, property, field, node, map);
                    continue;
                }
                this.fillUpdatedCollectionProperty(entity, currentNode, property, field, node, map);
                continue;
            }
            if (currentNode == null) {
                this.fillPrimitiveProperty(entity, keySet, property, field, node, map);
                continue;
            }
            if (currentNode instanceof String) {
                this.fillEntryFeed(entity, currentNode, property, field, node, map);
                continue;
            }
            this.fillUpdatedObjectProperty(entity, currentNode, property, field, node, map);
        }
    }
}

