/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.json.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JsonProcessor.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    public static final String ODATA = "@odata";
    public static final String ODATA_BIND = "@odata.bind";
    public static final String SVC_EXTENSION = ".svc/";
    private final String inputJson;
    private Map<String, String> odataValues = new HashMap<String, String>();
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<String, Object> links = new TreeMap<String, Object>();

    public JsonProcessor(String bodyText) {
        if (bodyText == null) {
            throw new IllegalArgumentException();
        }
        this.inputJson = bodyText;
    }

    public void initialize() throws ODataUnmarshallingException {
        LOG.info("Parser is initializing");
        try {
            JsonParser jsonParser = JSON_FACTORY.createParser(this.inputJson);
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String token = jsonParser.getCurrentName();
                if (token == null) continue;
                if (token.startsWith(ODATA)) {
                    this.processSpecialTags(jsonParser);
                    continue;
                }
                if (token.endsWith(ODATA_BIND)) {
                    this.processLinks(jsonParser);
                    continue;
                }
                this.process(jsonParser);
            }
        }
        catch (IOException e) {
            throw new ODataUnmarshallingException("It is unable to unmarshall", (Throwable)e);
        }
    }

    private void process(JsonParser jsonParser) throws IOException, ODataUnmarshallingException {
        if (jsonParser.getCurrentToken() == JsonToken.FIELD_NAME) {
            LOG.info("Starting to parse {} token", (Object)jsonParser.getCurrentName());
            String key = jsonParser.getCurrentName();
            jsonParser.nextToken();
            JsonToken token = jsonParser.getCurrentToken();
            if (token == JsonToken.START_ARRAY) {
                if ("value".equals(key)) {
                    throw new ODataUnmarshallingException("Feed is not supported");
                }
                this.values.put(key, this.getCollectionValue(jsonParser));
            } else if (token == JsonToken.START_OBJECT) {
                this.values.put(key, this.getEmbeddedObject(jsonParser));
            } else if (token.equals((Object)JsonToken.VALUE_NULL)) {
                this.values.put(key, null);
            } else {
                this.values.put(key, jsonParser.getText());
            }
        }
    }

    private List<Object> getCollectionValue(JsonParser jsonParser) throws IOException {
        LOG.info("Start parsing {} array", (Object)jsonParser.getCurrentName());
        ArrayList<Object> list = new ArrayList<Object>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                Object embedded = this.getEmbeddedObject(jsonParser);
                list.add(embedded);
            }
            if (!"}".equals(jsonParser.getText())) {
                list.add(jsonParser.getText());
                continue;
            }
            LOG.info("Array is over.");
        }
        return list;
    }

    private Object getEmbeddedObject(JsonParser jsonParser) throws IOException {
        LOG.info("Start parsing an embedded object.");
        HashMap<String, Object> embeddedMap = new HashMap<String, Object>();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String key = jsonParser.getText();
            jsonParser.nextToken();
            JsonToken token = jsonParser.getCurrentToken();
            if (token == JsonToken.START_ARRAY) {
                List<Object> embeddedArray = this.getCollectionValue(jsonParser);
                embeddedMap.put(key, embeddedArray);
                continue;
            }
            if (token == JsonToken.START_OBJECT) {
                Object embeddedObject = this.getEmbeddedObject(jsonParser);
                embeddedMap.put(key, embeddedObject);
                continue;
            }
            if (token.equals((Object)JsonToken.VALUE_NULL)) {
                embeddedMap.put(key, null);
                continue;
            }
            embeddedMap.put(key, jsonParser.getText());
        }
        return embeddedMap;
    }

    private void processSpecialTags(JsonParser jsonParser) throws IOException {
        LOG.info("@odata tags found - start parsing");
        String key = jsonParser.getCurrentName();
        jsonParser.nextToken();
        String value = jsonParser.getText();
        this.odataValues.put(key, value);
    }

    private void processLinks(JsonParser jsonParser) throws IOException {
        LOG.info("@odata.bind tag found - start parsing");
        String fullLinkFieldName = jsonParser.getText();
        String key = fullLinkFieldName.substring(0, fullLinkFieldName.indexOf(ODATA_BIND));
        JsonToken token = jsonParser.nextToken();
        if (token != JsonToken.START_ARRAY) {
            this.links.put(key, this.processLink(jsonParser));
        } else {
            ArrayList<String> linksList = new ArrayList<String>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                linksList.add(this.processLink(jsonParser));
            }
            this.links.put(key, linksList);
        }
    }

    private String processLink(JsonParser jsonParser) throws IOException {
        String link = jsonParser.getText();
        if (link.contains(SVC_EXTENSION)) {
            return link.substring(link.indexOf(SVC_EXTENSION) + SVC_EXTENSION.length());
        }
        return link;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Map<String, String> getODataValues() {
        return this.odataValues;
    }

    public Map<String, Object> getLinks() {
        return this.links;
    }
}

