/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.json.core;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.util.PrimitiveUtil;
import com.sdl.odata.util.ReferenceUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonParserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonParserUtils.class);

    private JsonParserUtils() {
    }

    public static StructuredType getStructuredType(String entityName, EntityDataModel edm) {
        Type type = edm.getType(entityName);
        if (JsonParserUtils.isStructuredType(type)) {
            return (StructuredType)type;
        }
        return null;
    }

    public static List<StructuralProperty> getAllProperties(StructuredType structuredType, EntityDataModel entityDataModel) throws ODataException {
        ArrayList<StructuralProperty> properties = new ArrayList<StructuralProperty>();
        String baseTypeName = structuredType.getBaseTypeName();
        if (!ReferenceUtil.isNullOrEmpty((String)baseTypeName)) {
            StructuredType baseType = (StructuredType)entityDataModel.getType(baseTypeName);
            if (baseType == null) {
                throw new ODataUnmarshallingException("OData type not found: " + baseTypeName);
            }
            properties.addAll(JsonParserUtils.getAllProperties(baseType, entityDataModel));
        }
        properties.addAll(structuredType.getStructuralProperties());
        LOG.info("Total number of properties returning are {} for given structured type {}", (Object)properties.size(), (Object)structuredType.getName());
        return properties;
    }

    public static Object getAppropriateFieldValue(Class<?> type, String fieldValue) throws ODataUnmarshallingException {
        Class wrappedType = PrimitiveUtil.wrap(type);
        if (String.class.isAssignableFrom(wrappedType)) {
            return fieldValue;
        }
        if (wrappedType == byte[].class) {
            return Base64.decodeBase64((String)fieldValue);
        }
        if (UUID.class.isAssignableFrom(wrappedType)) {
            return UUID.fromString(fieldValue);
        }
        if (JsonParserUtils.hasMethod(wrappedType, "parse", String.class)) {
            try {
                return wrappedType.getMethod("parse", String.class).invoke(null, fieldValue);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new ODataUnmarshallingException(e.getMessage(), (Throwable)e);
            }
        }
        if (JsonParserUtils.hasMethod(wrappedType, "valueOf", String.class)) {
            try {
                return wrappedType.getMethod("valueOf", String.class).invoke(null, fieldValue);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new ODataUnmarshallingException(e.getMessage(), (Throwable)e);
            }
        }
        if (wrappedType == ZonedDateTime.class) {
            return ZonedDateTime.parse(fieldValue);
        }
        return null;
    }

    public static void setFieldValue(Field field, Object entity, Object value) throws ODataUnmarshallingException {
        try {
            field.setAccessible(true);
            field.set(entity, value);
            LOG.debug("'{}' is set with '{}'", (Object)field.getName(), value);
        }
        catch (IllegalAccessException e) {
            throw new ODataUnmarshallingException(e.getMessage(), (Throwable)e);
        }
    }

    protected static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(methodName, parameterTypes);
            return method != null;
        }
        catch (NoSuchMethodException e) {
            LOG.trace("Looking for method '{}' with parameter types {}", (Object)methodName, parameterTypes);
            return false;
        }
    }

    private static boolean isStructuredType(Type type) {
        return type != null && type instanceof StructuredType;
    }
}

