/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.json.core;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNullableValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNullableValidator.class);
    private final Map<String, Object> fields;
    private final Map<String, Object> links;

    public JsonNullableValidator(Map<String, Object> fields, Map<String, Object> links) {
        this.fields = fields;
        this.links = links;
    }

    public void ensureCollection(StructuredType entityType) throws ODataException {
        ArrayList missingCollectionPropertyName = new ArrayList();
        entityType.getStructuralProperties().stream().filter(property -> property.isCollection() && !(property instanceof NavigationProperty) && !property.isNullable()).forEach(property -> {
            LOG.debug("Validating non-nullable collection property : {}", (Object)property.getName());
            if (!this.fields.containsKey(property.getName())) {
                missingCollectionPropertyName.add(property.getName());
            }
        });
        if (missingCollectionPropertyName.size() != 0) {
            StringJoiner joiner = new StringJoiner(",");
            missingCollectionPropertyName.forEach(joiner::add);
            throw new ODataUnmarshallingException("The request does not specify the non-nullable collections: '" + joiner.toString() + ".");
        }
    }

    public void ensureNavigationProperties(StructuredType entityType) throws ODataException {
        ArrayList<String> missingNavigationPropertyNames = new ArrayList<String>();
        for (StructuralProperty property : entityType.getStructuralProperties()) {
            if (!(property instanceof NavigationProperty) || property.isNullable()) continue;
            LOG.debug("Validating non-nullable NavigationProperty property : {}", (Object)property.getName());
            if (this.links.containsKey(property.getName())) continue;
            missingNavigationPropertyNames.add(property.getName());
        }
        if (missingNavigationPropertyNames.size() != 0) {
            StringJoiner joiner = new StringJoiner(",");
            missingNavigationPropertyNames.forEach(joiner::add);
            throw new ODataUnmarshallingException("The request does not specify the navigation links for '" + joiner.toString() + ".");
        }
    }
}

