/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.json;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataNotImplementedException;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.unmarshaller.AbstractParser;
import com.sdl.odata.unmarshaller.json.core.JsonNullableValidator;
import com.sdl.odata.unmarshaller.json.core.JsonParserUtils;
import com.sdl.odata.unmarshaller.json.core.JsonProcessor;
import com.sdl.odata.unmarshaller.json.core.JsonPropertyExpander;
import com.sdl.odata.util.ReferenceUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataJsonParser
extends AbstractParser {
    private static final Logger LOG = LoggerFactory.getLogger(ODataJsonParser.class);
    private Map<String, Object> fields;
    private Map<String, String> odataValues;
    private Map<String, Object> links;

    public ODataJsonParser(ODataRequestContext request, ODataParser uriParser) {
        super(request, uriParser);
    }

    private void initializeProcessor(JsonProcessor processor) throws ODataUnmarshallingException {
        LOG.info("Trying to initialize processor: {}", (Object)processor.getClass().getSimpleName());
        processor.initialize();
        this.fields = processor.getValues();
        this.odataValues = processor.getODataValues();
        this.links = processor.getLinks();
    }

    @Override
    protected Object processEntity(String bodyText) throws ODataException {
        this.initializeProcessor(new JsonProcessor(bodyText));
        JsonPropertyExpander expander = new JsonPropertyExpander(this.getEntityDataModel());
        String entityName = this.getEntityName();
        Object entity = expander.loadEntity(entityName);
        StructuredType entityType = JsonParserUtils.getStructuredType(entityName, this.getEntityDataModel());
        if (this.getRequest().getMethod() == ODataRequest.Method.POST) {
            JsonNullableValidator validator = new JsonNullableValidator(this.fields, this.links);
            validator.ensureCollection(entityType);
            validator.ensureNavigationProperties(entityType);
        }
        expander.setEntityProperties(entity, entityType, this.fields, null);
        this.setEntityNavigationProperties(entity, JsonParserUtils.getStructuredType(entityName, this.getEntityDataModel()));
        return entity;
    }

    @Override
    protected List<?> processEntities(String bodyText) throws ODataException {
        throw new ODataNotImplementedException("Unmarshalling a feed using JSON is not supported.");
    }

    private String getEntityName() throws ODataUnmarshallingException {
        String odataType = this.odataValues.get("@odata.type");
        if (ReferenceUtil.isNullOrEmpty((String)odataType)) {
            TargetType targetType = this.getTargetType();
            if (targetType == null) {
                throw new ODataUnmarshallingException("Could not find entity name");
            }
            return targetType.typeName();
        }
        if (odataType.startsWith("#")) {
            odataType = odataType.substring(1);
        }
        return odataType;
    }

    protected void setEntityNavigationProperties(Object entity, StructuredType entityType) throws ODataException {
        for (Map.Entry<String, Object> entry : this.links.entrySet()) {
            String propertyName = entry.getKey();
            Object entryLinks = entry.getValue();
            LOG.debug("Found link for navigation property: {}", (Object)propertyName);
            StructuralProperty property = entityType.getStructuralProperty(propertyName);
            if (!(property instanceof NavigationProperty)) {
                throw new ODataUnmarshallingException("The request contains a navigation link '" + propertyName + "' but the entity type '" + entityType + "' does not contain a navigation property " + "with this name.");
            }
            if (!this.isWriteOperation()) continue;
            if (entryLinks instanceof List) {
                List linksList = (List)entryLinks;
                for (String link : linksList) {
                    Object referencedEntity = this.getReferencedEntity(link, propertyName);
                    LOG.debug("Referenced entity: {}", referencedEntity);
                    this.saveReferencedEntity(entity, propertyName, property, referencedEntity);
                }
                continue;
            }
            Object referencedEntity = this.getReferencedEntity((String)entryLinks, propertyName);
            LOG.debug("Referenced entity: {}", referencedEntity);
            this.saveReferencedEntity(entity, propertyName, property, referencedEntity);
        }
    }
}

