/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.json;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.unmarshaller.AbstractUnmarshaller;
import com.sdl.odata.unmarshaller.json.ODataJsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JsonUnmarshaller
extends AbstractUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUnmarshaller.class);
    @Autowired
    private ODataParser uriParser;

    public int score(ODataRequestContext requestContext) {
        if (this.isRightMethodForUnmarshall(requestContext.getRequest()) && !ODataUriUtil.isRefPathUri((ODataUri)requestContext.getUri())) {
            MediaType contentType = requestContext.getRequest().getContentType();
            int score = super.score(contentType, MediaType.JSON);
            LOG.debug("Match for JsonUnmarshaller: {} with score: {}", (Object)requestContext.getRequest(), (Object)score);
            return score;
        }
        return 0;
    }

    public Object unmarshall(ODataRequestContext requestContext) throws ODataException {
        LOG.info("Json Unmarshaller invoked with {}", (Object)requestContext.getRequest());
        return new ODataJsonParser(requestContext, this.uriParser).getODataEntity();
    }
}

