/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.unmarshaller.AbstractLinkUnmarshaller;
import com.sdl.odata.util.ReferenceUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.springframework.stereotype.Component;

@Component
public class JsonLinkUnmarshaller
extends AbstractLinkUnmarshaller {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[]{MediaType.JSON};

    @Override
    protected MediaType[] supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    protected String getToEntityId(ODataRequestContext requestContext) throws ODataUnmarshallingException {
        String bodyText;
        try {
            bodyText = requestContext.getRequest().getBodyText(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException("UTF-8 is not supported", (Throwable)e);
        }
        String idValue = null;
        try {
            JsonToken token;
            JsonParser parser = new JsonFactory().createParser(bodyText);
            while (idValue == null && !parser.isClosed() && (token = parser.nextToken()) != null) {
                if (!token.equals((Object)JsonToken.FIELD_NAME) || !parser.getCurrentName().equals("@odata.id") || !(token = parser.nextToken()).equals((Object)JsonToken.VALUE_STRING)) continue;
                idValue = parser.getText();
            }
        }
        catch (IOException e) {
            throw new ODataUnmarshallingException("Error while parsing JSON data", (Throwable)e);
        }
        if (ReferenceUtil.isNullOrEmpty(idValue)) {
            throw new ODataUnmarshallingException("The JSON object in the body has no '@odata.id' value, or the value is empty. The JSON object in the body must have an '@odata.id' value that refers to the entity to link to.");
        }
        return idValue;
    }
}

