/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.batch;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataRequestContextUtil;
import com.sdl.odata.unmarshaller.AbstractUnmarshaller;
import com.sdl.odata.unmarshaller.batch.ODataBatchParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchUnmarshaller
extends AbstractUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(BatchUnmarshaller.class);
    private static final int BATCH_OPERATION_SCORE = 50;
    @Autowired
    private ODataParser uriParser;

    public int score(ODataRequestContext requestContext) {
        if (this.isRightMethodForUnmarshall(requestContext.getRequest()) && ODataRequestContextUtil.isBatchOperation((ODataRequestContext)requestContext)) {
            MediaType contentType = requestContext.getRequest().getContentType();
            int score = 50 + super.score(contentType, MediaType.MULTIPART);
            LOG.debug("Matched MultipartUnmarshaller: {} with score: {}", (Object)requestContext.getRequest(), (Object)score);
            return score;
        }
        return 0;
    }

    public Object unmarshall(ODataRequestContext requestContext) throws ODataException {
        LOG.info("Multipart unmarshaller invoked with {}", (Object)requestContext.getRequest());
        return new ODataBatchParser(requestContext, this.uriParser).getODataEntity();
    }
}

