/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.atom;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataNotImplementedException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.edm.model.ComplexType;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.EnumType;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.PrimitiveType;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.parser.util.ParserUtil;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.unmarshaller.AbstractParser;
import com.sdl.odata.unmarshaller.PropertyType;
import com.sdl.odata.util.ReferenceUtil;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ODataAtomParser
extends AbstractParser {
    private static final Logger LOG = LoggerFactory.getLogger(ODataAtomParser.class);
    private final Set<String> foundCollectionProperties = new HashSet<String>();
    private static final int COLLECTION_INDEX = 11;
    public static final DocumentBuilderFactory DOCBUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public ODataAtomParser(ODataRequestContext context, ODataParser uriParser) {
        super(context, uriParser);
    }

    @Override
    protected Object processEntity(String bodyText) throws ODataException {
        return this.processEntity(this.parseXML(bodyText).getDocumentElement());
    }

    @Override
    protected List<?> processEntities(String bodyText) throws ODataException {
        return this.processEntities(this.parseXML(bodyText).getDocumentElement());
    }

    private Document parseXML(String xml) throws ODataUnmarshallingException {
        try {
            return DOCBUILDER_FACTORY.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (SAXException e) {
            throw new ODataUnmarshallingException("Error while parsing XML", (Throwable)e);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new ODataSystemException((Throwable)e);
        }
    }

    private Object processEntity(Element entryElement) throws ODataException {
        Object entity;
        if (!entryElement.getNodeName().equals("entry")) {
            throw new ODataUnmarshallingException("Expected <entry> as the root element, but found: " + entryElement.getNodeName());
        }
        EntityType entityType = this.getEntityType(entryElement);
        try {
            Class javaType = entityType.getJavaType();
            LOG.debug("Creating new instance of type: {}", (Object)javaType.getName());
            entity = javaType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ODataUnmarshallingException("Error while instantiating entity of type: " + entityType.getFullyQualifiedName(), (Throwable)e);
        }
        this.setEntityProperties(entity, entityType, entryElement);
        this.setEntityNavigationProperties(entity, entityType, entryElement);
        this.ensureNonNullableCollectionArePresent((StructuredType)entityType);
        return entity;
    }

    private List<?> processEntities(Element feedElement) throws ODataException {
        this.checkFeedMetadata(feedElement);
        ArrayList<Object> entities = new ArrayList<Object>();
        for (Element feedEntry : this.getFeedEntries(feedElement)) {
            entities.add(this.processEntity(feedEntry));
        }
        return entities;
    }

    protected String getOdataSchemeNS() {
        return "http://docs.oasis-open.org/odata/ns/scheme";
    }

    protected String getEntityTerm(Element element) {
        String entityTypeName = null;
        String term = element.getAttribute("term") == null ? "" : element.getAttribute("term");
        int index = term.lastIndexOf(35);
        if (index >= 0 && term.length() > index + 1) {
            entityTypeName = term.substring(index + 1);
        }
        return entityTypeName;
    }

    private EntityType getEntityType(Element entryElement) throws ODataUnmarshallingException {
        NodeList elements = entryElement.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "category");
        for (int i = elements.getLength() - 1; i >= 0; --i) {
            Element element = (Element)elements.item(i);
            String scheme = element.getAttribute("scheme");
            if (scheme != null && scheme.equals(this.getOdataSchemeNS())) {
                String entityTypeName = this.getEntityTerm(element);
                if (entityTypeName == null) {
                    throw new ODataUnmarshallingException("Found a <category> element, but its term attribute does not correctly specify the entity type: term=\"" + element.getAttribute("term") + "\"");
                }
                LOG.debug("Found entity type name: {}", (Object)entityTypeName);
                Type type = this.getEntityDataModel().getType(entityTypeName);
                if (type == null) {
                    throw new ODataUnmarshallingException("Entity type does not exist in the entity data model: " + entityTypeName);
                }
                if (type.getMetaType() != MetaType.ENTITY) {
                    throw new ODataUnmarshallingException("This type exists in the entity data model, but it is not an entity type: " + entityTypeName + "; it is: " + type.getMetaType());
                }
                return (EntityType)type;
            }
            LOG.debug("Found a <category> element with an unexpected 'scheme' attribute: " + scheme);
        }
        throw new ODataUnmarshallingException("No <category> element found with attribute scheme=\"" + this.getOdataSchemeNS() + "\" that specifies the entity type.");
    }

    protected String getODataMetadataNS() {
        return "http://docs.oasis-open.org/odata/ns/metadata";
    }

    private void setEntityProperties(Object entity, EntityType entityType, Element entryElement) throws ODataException {
        LOG.trace("setEntityProperties: entityType={}", (Object)entityType);
        NodeList childNodes = entryElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("content")) continue;
            Element contentElement = (Element)node;
            NodeList propertiesElements = contentElement.getElementsByTagNameNS(this.getODataMetadataNS(), "properties");
            for (int j = 0; j < propertiesElements.getLength(); ++j) {
                Element propertiesElement = (Element)propertiesElements.item(j);
                NodeList propertyNodes = propertiesElement.getChildNodes();
                for (int k = 0; k < propertyNodes.getLength(); ++k) {
                    Node propertyNode = propertyNodes.item(k);
                    if (!(propertyNode instanceof Element)) continue;
                    this.setStructProperty(entity, (StructuredType)entityType, (Element)propertyNode);
                }
            }
        }
    }

    private void setStructProperty(Object instance, StructuredType structType, Element propertyElement) throws ODataException {
        Object propertyValue;
        String propertyName = propertyElement.getLocalName();
        LOG.debug("Found property element: {}", (Object)propertyName);
        PropertyType propertyTypeFromXML = this.getPropertyTypeFromXML(propertyElement);
        LOG.debug("Property type from XML: {}", (Object)propertyTypeFromXML);
        StructuralProperty property = EntityDataModelUtil.getStructuralProperty((EntityDataModel)this.getEntityDataModel(), (StructuredType)structType, (String)propertyName);
        if (property == null) {
            if (!structType.isOpen()) {
                throw new ODataUnmarshallingException("The request body contains a property that does not exist in the structured type: " + structType + ", property: " + propertyName);
            }
            throw new ODataNotImplementedException("Open types are not supported, cannot set property value for property '" + propertyName + "' in instance of type: " + structType);
        }
        if (propertyTypeFromXML.isCollection()) {
            if (!property.isCollection()) {
                throw new ODataUnmarshallingException("The type of the property '" + propertyName + "' is a " + "collection type: " + propertyTypeFromXML + ", but according to the entity data model it " + "is not a collection: " + property.getTypeName());
            }
        } else if (property.isCollection()) {
            throw new ODataUnmarshallingException("The type of the property '" + propertyName + "' is not a " + "collection type: " + propertyTypeFromXML + ", but according to the entity data model it " + "is a collection: " + property.getTypeName());
        }
        if (propertyTypeFromXML.isCollection()) {
            this.foundCollectionProperties.add(propertyName);
            Class<?> fieldType = property.getJavaField().getType();
            propertyValue = this.parsePropertyValueCollection(propertyElement, propertyTypeFromXML.getType(), fieldType);
        } else {
            propertyValue = this.parsePropertyValueSingle(propertyElement, propertyTypeFromXML.getType());
        }
        boolean notNullableProperty = propertyValue != null;
        LOG.debug("Property value: {} ({})", propertyValue, (Object)(notNullableProperty ? propertyValue.getClass().getName() : "<null>"));
        try {
            Field field = property.getJavaField();
            field.setAccessible(true);
            field.set(instance, propertyValue);
        }
        catch (IllegalAccessException e) {
            throw new ODataUnmarshallingException("Error while setting property value for property '" + propertyName + "': " + propertyValue, (Throwable)e);
        }
    }

    private PropertyType getPropertyTypeFromXML(Element propertyElement) throws ODataUnmarshallingException {
        Type type;
        int index;
        String propertyName = propertyElement.getLocalName();
        boolean collection = false;
        String typeName = propertyElement.getAttributeNS(this.getODataMetadataNS(), "type");
        if (ReferenceUtil.isNullOrEmpty((String)typeName)) {
            typeName = PrimitiveType.STRING.getName();
        }
        if ((index = typeName.lastIndexOf(35)) >= 0) {
            if (typeName.length() < index + 1) {
                throw new ODataUnmarshallingException("The type attribute is specified incorrectly on this property element: <" + propertyName + " type=\"" + typeName + "\">");
            }
            typeName = typeName.substring(index + 1);
        }
        if (typeName.startsWith("Collection(")) {
            collection = true;
            typeName = typeName.substring(11, typeName.length() - 1);
        }
        if (typeName.indexOf(46) < 0) {
            typeName = "Edm." + typeName;
        }
        if (typeName.equals("Edm.DateTime")) {
            typeName = "Edm." + PrimitiveType.DATE_TIME_OFFSET.getName();
        }
        if ((type = this.getEntityDataModel().getType(typeName)) == null) {
            throw new ODataUnmarshallingException("The type of the property '" + propertyName + "' does not exist " + "in the entity data model: " + typeName);
        }
        return new PropertyType(type, collection);
    }

    private Object parsePropertyValueCollection(Element propertyElement, Type elementType, Class<?> javaCollectionType) throws ODataException {
        AbstractCollection result;
        if (List.class.isAssignableFrom(javaCollectionType)) {
            result = new ArrayList();
        } else if (Set.class.isAssignableFrom(javaCollectionType)) {
            result = new HashSet();
        } else {
            throw new ODataNotImplementedException("Unsupported collection type: " + javaCollectionType.getName() + "; only List and Set are supported");
        }
        NodeList elements = propertyElement.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!"element".equals(node.getLocalName()) || !this.getODataMetadataNS().equals(node.getNamespaceURI())) continue;
            Element element = (Element)node;
            result.add(this.parsePropertyValueSingle(element, elementType));
        }
        return result;
    }

    private Object parsePropertyValueSingle(Element propertyElement, Type type) throws ODataException {
        String nullAttr = propertyElement.getAttributeNS(this.getODataMetadataNS(), "null");
        if (nullAttr != null && nullAttr.equals("true")) {
            return null;
        }
        switch (type.getMetaType()) {
            case PRIMITIVE: {
                return this.parsePropertyValuePrimitive(propertyElement, (PrimitiveType)type);
            }
            case ENUM: {
                return this.parsePropertyValueEnum(propertyElement, (EnumType)type);
            }
            case COMPLEX: {
                return this.parsePropertyValueComplex(propertyElement, (ComplexType)type);
            }
        }
        throw new ODataUnmarshallingException("The property '" + propertyElement.getLocalName() + "' must be " + "of a PRIMITIVE, ENUM or COMPLEX type; something else was found instead: " + type + " (" + type.getMetaType() + ")");
    }

    private Object parsePropertyValuePrimitive(Element propertyElement, PrimitiveType primitiveType) throws ODataException {
        return ParserUtil.parsePrimitiveValue((String)propertyElement.getTextContent().trim(), (PrimitiveType)primitiveType);
    }

    private Object parsePropertyValueEnum(Element propertyElement, EnumType enumType) throws ODataException {
        String text = propertyElement.getTextContent().trim();
        String[] values = text.split(",");
        if (values.length > 1) {
            throw new ODataNotImplementedException("Multiple enum values are not supported, type: " + enumType + " for value: " + text);
        }
        return ParserUtil.parseEnumValue((String)values[0].trim(), (EnumType)enumType);
    }

    private Object parsePropertyValueComplex(Element propertyElement, ComplexType complexType) throws ODataException {
        Object instance;
        try {
            instance = complexType.getJavaType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ODataUnmarshallingException("Error while instantiating instance of complex type: " + complexType.getFullyQualifiedName(), (Throwable)e);
        }
        NodeList nodes = propertyElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.setStructProperty(instance, (StructuredType)complexType, (Element)node);
        }
        return instance;
    }

    protected String getODataNavLinkRelationNSPrefix() {
        return "http://docs.oasis-open.org/odata/ns/related/";
    }

    private void setEntityNavigationProperties(Object entity, EntityType entityType, Element entryElement) throws ODataException {
        HashSet<String> foundNavigationProperties = new HashSet<String>();
        NodeList childNodes = entryElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String relAttribute;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("link")) continue;
            Element linkElement = (Element)node;
            String string = relAttribute = linkElement.getAttribute("rel") == null ? "" : linkElement.getAttribute("rel");
            if (!relAttribute.startsWith(this.getODataNavLinkRelationNSPrefix())) continue;
            foundNavigationProperties.add(this.processNavigationLink(entity, entityType, linkElement));
        }
        this.ensureNonNullableNavigationPropertiesArePresent(foundNavigationProperties, (StructuredType)entityType);
    }

    private String processNavigationLink(Object entity, EntityType entityType, Element linkElement) throws ODataException {
        String propertyName = linkElement.getAttribute("rel").substring(this.getODataNavLinkRelationNSPrefix().length());
        LOG.debug("Found link element for navigation property: {}", (Object)propertyName);
        StructuralProperty property = entityType.getStructuralProperty(propertyName);
        if (!(property instanceof NavigationProperty)) {
            throw new ODataUnmarshallingException("The request contains a navigation link '" + propertyName + "' but the entity type '" + entityType + "' does not contain a navigation property " + "with this name.");
        }
        this.processReferencedEntity(entity, entityType, linkElement);
        return propertyName;
    }

    private void processReferencedEntity(Object entity, EntityType entityType, Element linkElement) throws ODataException {
        String propertyName = linkElement.getAttribute("rel").substring(this.getODataNavLinkRelationNSPrefix().length());
        StructuralProperty property = entityType.getStructuralProperty(propertyName);
        if (this.isWriteOperation()) {
            String hrefAttr;
            String string = hrefAttr = linkElement.getAttribute("href") == null ? "" : linkElement.getAttribute("href");
            if (hrefAttr.isEmpty()) {
                throw new ODataUnmarshallingException("The request contains a navigation link for the property '" + propertyName + "' but the element 'href' is empty.");
            }
            Object referencedEntity = this.getReferencedEntity(hrefAttr, propertyName);
            LOG.debug("Referenced entity: {}", referencedEntity);
            this.saveReferencedEntity(entity, propertyName, property, referencedEntity);
        } else {
            Element inlineEntry = this.getInlineEntry(linkElement);
            if (inlineEntry != null) {
                Object linkedEntry = this.processEntity(inlineEntry);
                LOG.debug("Linked entry: {}", linkedEntry);
                this.saveReferencedEntity(entity, propertyName, property, linkedEntry);
            } else {
                Element inlineFeed = this.getInlineFeed(linkElement);
                if (inlineFeed != null) {
                    List<?> linkedFeed = this.processEntities(inlineFeed);
                    for (Object linkedEntry : linkedFeed) {
                        LOG.debug("Linked feed entry: {}", linkedEntry);
                        this.saveReferencedEntity(entity, propertyName, property, linkedEntry);
                    }
                }
            }
        }
    }

    protected void checkFeedMetadata(Element feedElement) throws ODataUnmarshallingException {
        ArrayList<Element> feedMetadataElements = new ArrayList<Element>();
        NodeList childNodes = feedElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!this.isFeedMetadataElement(node)) continue;
            feedMetadataElements.add((Element)node);
        }
        if (feedMetadataElements.size() < 4) {
            throw new ODataUnmarshallingException("Feed metadata information missing. Expected metadata: '<id>', '<title>', '<updated>', '<link>'");
        }
        this.checkFeedMetadata((Element)feedMetadataElements.get(0), "id");
        this.checkFeedMetadata((Element)feedMetadataElements.get(1), "title");
        this.checkFeedMetadata((Element)feedMetadataElements.get(2), "updated");
        this.checkFeedMetadata((Element)feedMetadataElements.get(3), "link");
    }

    protected void checkFeedMetadata(Element feedMetadataElement, String nodeLocalName) throws ODataUnmarshallingException {
        if (!nodeLocalName.equals(feedMetadataElement.getLocalName())) {
            throw new ODataUnmarshallingException("Wrong Feed metadata. Found: '" + feedMetadataElement.getLocalName() + "'. Expected: '" + nodeLocalName + "'");
        }
    }

    private boolean isFeedMetadataElement(Node node) {
        if (node instanceof Element) {
            String nodeLocalName = node.getLocalName();
            return "id".equals(nodeLocalName) || "title".equals(nodeLocalName) || "updated".equals(nodeLocalName) || "link".equals(nodeLocalName);
        }
        return false;
    }

    private List<Element> getFeedEntries(Element feedElement) {
        ArrayList<Element> feedEntries = new ArrayList<Element>();
        NodeList childNodes = feedElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !"entry".equals(node.getLocalName())) continue;
            feedEntries.add((Element)node);
        }
        return feedEntries;
    }

    private Element getInlineEntry(Element linkElement) throws ODataUnmarshallingException {
        Element entryElement;
        Element inlineElement = this.getInlineElement(linkElement);
        if (inlineElement != null && (entryElement = this.getFirstChildElement(inlineElement)) != null && "entry".equals(entryElement.getLocalName())) {
            return entryElement;
        }
        return null;
    }

    private Element getInlineFeed(Element linkElement) throws ODataUnmarshallingException {
        Element feedElement;
        Element inlineElement = this.getInlineElement(linkElement);
        if (inlineElement != null && (feedElement = this.getFirstChildElement(inlineElement)) != null && "feed".equals(feedElement.getLocalName())) {
            return feedElement;
        }
        return null;
    }

    private Element getInlineElement(Element linkElement) throws ODataUnmarshallingException {
        Element inlineElement = this.getFirstChildElement(linkElement);
        if (inlineElement != null && "inline".equals(inlineElement.getLocalName()) && this.getODataMetadataNS().equals(inlineElement.getNamespaceURI())) {
            return inlineElement;
        }
        return null;
    }

    private Element getFirstChildElement(Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    private void ensureNonNullableCollectionArePresent(StructuredType entityType) throws ODataException {
        if (this.getRequest().getMethod() != ODataRequest.Method.POST) {
            return;
        }
        ArrayList missingCollectionPropertyName = new ArrayList();
        entityType.getStructuralProperties().stream().filter(property -> property.isCollection() && !(property instanceof NavigationProperty) && !property.isNullable()).forEach(property -> {
            LOG.debug("Validating non-nullable collection property : {}", (Object)property.getName());
            if (!this.foundCollectionProperties.contains(property.getName())) {
                missingCollectionPropertyName.add(property.getName());
            }
        });
        if (missingCollectionPropertyName.size() != 0) {
            StringJoiner joiner = new StringJoiner(",");
            missingCollectionPropertyName.forEach(joiner::add);
            LOG.debug("Non-nullable collections of {} are not found in the request" + missingCollectionPropertyName);
            throw new ODataUnmarshallingException("The request does not specify the non-nullable collections: '" + joiner.toString() + ".");
        }
    }

    private void ensureNonNullableNavigationPropertiesArePresent(Set<String> navigationPropertyNames, StructuredType entityType) throws ODataException {
        if (this.getRequest().getMethod() != ODataRequest.Method.POST) {
            return;
        }
        ArrayList missingNavigationPropertyNames = new ArrayList();
        entityType.getStructuralProperties().stream().filter(property -> property instanceof NavigationProperty && !property.isNullable()).forEach(property -> {
            LOG.debug("Validating non-nullable property : {}", (Object)property.getName());
            if (!navigationPropertyNames.contains(property.getName())) {
                missingNavigationPropertyNames.add(property.getName());
            }
        });
        if (missingNavigationPropertyNames.size() != 0) {
            LOG.debug("Non-nullable navigation properties of {} are not found in the request" + missingNavigationPropertyNames);
        }
    }

    static {
        DOCBUILDER_FACTORY.setNamespaceAware(true);
    }
}

