/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.atom;

import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.unmarshaller.AbstractLinkUnmarshaller;
import com.sdl.odata.util.ReferenceUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component
public class AtomLinkUnmarshaller
extends AbstractLinkUnmarshaller {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[]{MediaType.ATOM_XML, MediaType.XML};

    @Override
    protected MediaType[] supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    protected String getToEntityId(ODataRequestContext requestContext) throws ODataUnmarshallingException {
        String bodyText;
        try {
            bodyText = requestContext.getRequest().getBodyText(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException("UTF-8 is not supported", (Throwable)e);
        }
        Document document = this.parseXML(bodyText);
        Element rootElement = document.getDocumentElement();
        if (!rootElement.getNodeName().equals("ref")) {
            throw new ODataUnmarshallingException("A " + requestContext.getRequest().getMethod() + " request to an entity reference URI must contain a single entity reference in the body," + " but something else was found instead: " + rootElement.getNodeName());
        }
        String idAttr = rootElement.getAttribute("id");
        if (ReferenceUtil.isNullOrEmpty((String)idAttr)) {
            throw new ODataUnmarshallingException("The <metadata:ref> element in the body has no 'id' attribute, or the attribute is empty. The element must have an 'id' attribute that refers to the entity to link to.");
        }
        return idAttr;
    }

    private Document parseXML(String xml) throws ODataUnmarshallingException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (SAXException e) {
            throw new ODataUnmarshallingException("Error while parsing XML", (Throwable)e);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new ODataSystemException((Throwable)e);
        }
    }
}

