/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller.atom;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.unmarshaller.AbstractUnmarshaller;
import com.sdl.odata.unmarshaller.atom.ODataAtomActionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtomActionUnmarshaller
extends AbstractUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(AtomActionUnmarshaller.class);
    private static final int ACTION_OPERATION_SCORE = 50;

    public int score(ODataRequestContext requestContext) {
        if (this.isRightMethodForUnmarshall(requestContext.getRequest()) && ODataUriUtil.isActionCallUri((ODataUri)requestContext.getUri())) {
            MediaType contentType = requestContext.getRequest().getContentType();
            int baseScore = super.score(contentType, MediaType.ATOM_XML, MediaType.XML);
            int actionScore = 0;
            if (baseScore > 0) {
                actionScore = baseScore + 50;
            }
            LOG.debug("Match for AtomActionUnmarshaller: {} with score: {}", (Object)requestContext.getRequest(), (Object)actionScore);
            return actionScore;
        }
        return 0;
    }

    public Object unmarshall(ODataRequestContext requestContext) throws ODataException {
        LOG.debug("Unmarshalling action parameters from request: {}", (Object)requestContext.getRequest().toString());
        return new ODataAtomActionParser(requestContext).getAction();
    }
}

