/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.parser.FromEntity;
import com.sdl.odata.api.parser.IdOption;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.processor.link.ODataLink;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.unmarshaller.AbstractUnmarshaller;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Option;

@Component
public class DeleteLinkUnmarshaller
extends AbstractUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteLinkUnmarshaller.class);
    @Autowired
    private ODataParser uriParser;

    public int score(ODataRequestContext requestContext) {
        if (this.isDeleteMethod(requestContext.getRequest().getMethod()) && ODataUriUtil.isRefPathUri((ODataUri)requestContext.getUri())) {
            LOG.debug("Match for DeleteLinkUnmarshaller: {}", (Object)requestContext.getRequest());
            return 100;
        }
        return 0;
    }

    public Object unmarshall(ODataRequestContext requestContext) throws ODataException {
        EntityDataModel entityDataModel = requestContext.getEntityDataModel();
        Option fromEntityOption = ODataUriUtil.getFromEntity((ODataUri)requestContext.getUri(), (EntityDataModel)entityDataModel);
        if (fromEntityOption.isEmpty()) {
            throw new ODataBadRequestException("The URI of a DELETE request to delete a link must refer to a navigation property of a specific entity. This information could not be determined from the URI: " + requestContext.getRequest().getUri());
        }
        FromEntity fromEntity = (FromEntity)fromEntityOption.get();
        Option idOption = ODataUriUtil.getIdOption((ODataUri)requestContext.getUri());
        if (fromEntity.navigationProperty().isCollection()) {
            if (idOption.isEmpty()) {
                throw new ODataBadRequestException("The URI of a DELETE request to delete a link for a collection navigation property must have an '$id' option that identifies the entity to remove from the collection.");
            }
            ODataUri idUri = this.uriParser.parseUri(((IdOption)idOption.get()).value(), entityDataModel);
            return new ODataLink(fromEntity.entityType(), fromEntity.navigationProperty(), fromEntity.entityKey(), ODataUriUtil.getEntityKeyMap((ODataUri)idUri, (EntityDataModel)entityDataModel));
        }
        if (idOption.isDefined()) {
            throw new ODataBadRequestException("The URI of a DELETE request to delete a link for a single value navigation property must not have an '$id' option.");
        }
        return new ODataLink(fromEntity.entityType(), fromEntity.navigationProperty(), fromEntity.entityKey(), ODataUriUtil.asScalaMap(Collections.emptyMap()));
    }
}

