/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller;

import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.unmarshaller.ODataUnmarshaller;

public abstract class AbstractUnmarshaller
implements ODataUnmarshaller {
    protected boolean isRightMethodForUnmarshall(ODataRequest request) {
        ODataRequest.Method method = request.getMethod();
        return this.isPostMethod(method) || this.isPatchMethod(method) || this.isPutMethod(method);
    }

    protected boolean isPostMethod(ODataRequest.Method method) {
        return ODataRequest.Method.POST.equals((Object)method);
    }

    protected boolean isPutMethod(ODataRequest.Method method) {
        return ODataRequest.Method.PUT.equals((Object)method);
    }

    protected boolean isPatchMethod(ODataRequest.Method method) {
        return ODataRequest.Method.PATCH.equals((Object)method);
    }

    protected boolean isDeleteMethod(ODataRequest.Method method) {
        return ODataRequest.Method.DELETE.equals((Object)method);
    }

    protected int score(MediaType contentTypeFromRequest, MediaType ... expectedTypes) {
        if (contentTypeFromRequest == null) {
            return 0;
        }
        for (MediaType expected : expectedTypes) {
            if (!contentTypeFromRequest.matches(expected)) continue;
            return 130;
        }
        return 0;
    }
}

