/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.RelativeUri;
import com.sdl.odata.api.parser.ResourcePath;
import com.sdl.odata.api.parser.ResourcePathUri;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.util.ReferenceUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.immutable.List;

public abstract class AbstractParser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractParser.class);
    private final EntityDataModel entityDataModel;
    private final ODataRequest request;
    private final ODataUri oDataUri;
    private final ODataParser uriParser;

    public AbstractParser(ODataRequestContext context, ODataParser oDataParser) {
        this.entityDataModel = ODataRendererUtils.checkNotNull(context.getEntityDataModel());
        this.request = ODataRendererUtils.checkNotNull(context.getRequest());
        this.oDataUri = ODataRendererUtils.checkNotNull(context.getUri());
        this.uriParser = ODataRendererUtils.checkNotNull(oDataParser);
    }

    public Object getODataEntity() throws ODataException {
        String bodyText = this.getBodyText();
        LOG.trace("Text of the body is {}", (Object)bodyText);
        if (!ReferenceUtil.isNullOrEmpty((String)bodyText)) {
            return this.processEntity(bodyText);
        }
        throw new ODataUnmarshallingException("Payload is empty. Expected an entry.");
    }

    public java.util.List<?> getODataEntities() throws ODataException {
        String bodyText = this.getBodyText();
        LOG.trace("Text of the body is {}", (Object)bodyText);
        if (!ReferenceUtil.isNullOrEmpty((String)bodyText)) {
            return this.processEntities(bodyText);
        }
        throw new ODataUnmarshallingException("Payload is empty. Expected a feed.");
    }

    protected abstract Object processEntity(String var1) throws ODataException;

    protected abstract java.util.List<?> processEntities(String var1) throws ODataException;

    protected String getBodyText() {
        try {
            return this.request.getBodyText(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
    }

    protected Type getType(String entityName) {
        return this.entityDataModel.getType(entityName);
    }

    protected ODataRequest getRequest() {
        return this.request;
    }

    protected ODataUri getODataUri() {
        return this.oDataUri;
    }

    protected TargetType getTargetType() {
        Option targetTypeOption = ODataUriUtil.resolveTargetType((ODataUri)this.oDataUri, (EntityDataModel)this.entityDataModel);
        if (targetTypeOption.isDefined()) {
            return (TargetType)targetTypeOption.get();
        }
        return null;
    }

    protected boolean isWriteOperation() {
        return !ODataRequest.Method.GET.equals((Object)this.request.getMethod());
    }

    protected Object getReferencedEntity(String entityIdResourcePath, String propertyName) throws ODataException {
        LOG.debug("getReferencedEntity: {}", (Object)entityIdResourcePath);
        ResourcePath resourcePath = this.uriParser.parseResourcePath(entityIdResourcePath, this.entityDataModel);
        ODataUri referencedEntityUri = new ODataUri("", (RelativeUri)new ResourcePathUri(resourcePath, List.empty()));
        Option opt = ODataUriUtil.extractEntityWithKeys((ODataUri)referencedEntityUri, (EntityDataModel)this.entityDataModel);
        if (!opt.isDefined()) {
            throw new ODataUnmarshallingException("Cannot determine referenced entity for navigation link for property: " + propertyName + ", href=\"" + entityIdResourcePath + "\"");
        }
        return opt.get();
    }

    protected void saveReferencedEntity(Object entity, String propertyName, StructuralProperty property, Object referencedEntity) throws ODataUnmarshallingException {
        Field field = property.getJavaField();
        field.setAccessible(true);
        try {
            if (java.util.List.class.isAssignableFrom(field.getType())) {
                this.saveReferencedEntityListField(entity, referencedEntity, field);
            } else if (Set.class.isAssignableFrom(field.getType())) {
                this.saveReferencedEntitySetField(entity, referencedEntity, field);
            } else {
                field.set(entity, referencedEntity);
            }
        }
        catch (IllegalAccessException e) {
            throw new ODataUnmarshallingException("Error while getting or setting navigation property field " + propertyName, (Throwable)e);
        }
    }

    private void saveReferencedEntitySetField(Object entity, Object referencedEntity, Field field) throws IllegalAccessException {
        HashSet<Object> set = (HashSet<Object>)field.get(entity);
        if (set == null) {
            set = new HashSet<Object>();
            field.set(entity, set);
        }
        set.add(referencedEntity);
    }

    private void saveReferencedEntityListField(Object entity, Object referencedEntity, Field field) throws IllegalAccessException {
        ArrayList<Object> list = (ArrayList<Object>)field.get(entity);
        if (list == null) {
            list = new ArrayList<Object>();
            field.set(entity, list);
        }
        list.add(referencedEntity);
    }

    public EntityDataModel getEntityDataModel() {
        return this.entityDataModel;
    }
}

