/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.parser.FromEntity;
import com.sdl.odata.api.parser.ODataParser;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriParseException;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.ResourcePath;
import com.sdl.odata.api.processor.link.ODataLink;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import com.sdl.odata.unmarshaller.AbstractUnmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Option;
import scala.collection.immutable.Map;

public abstract class AbstractLinkUnmarshaller
extends AbstractUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLinkUnmarshaller.class);
    @Autowired
    private ODataParser uriParser;

    protected abstract MediaType[] supportedMediaTypes();

    public int score(ODataRequestContext requestContext) {
        ODataRequest.Method method = requestContext.getRequest().getMethod();
        if ((this.isPostMethod(method) || this.isPutMethod(method)) && ODataUriUtil.isRefPathUri((ODataUri)requestContext.getUri())) {
            MediaType contentType = requestContext.getRequest().getContentType();
            int score = super.score(contentType, this.supportedMediaTypes());
            LOG.debug("Match for {}: {} with score: {}", new Object[]{this.getClass().getSimpleName(), requestContext.getRequest(), score});
            return score;
        }
        return 0;
    }

    protected abstract String getToEntityId(ODataRequestContext var1) throws ODataUnmarshallingException;

    public Object unmarshall(ODataRequestContext requestContext) throws ODataException {
        Map toEntityKey;
        EntityDataModel entityDataModel = requestContext.getEntityDataModel();
        Option fromEntityOption = ODataUriUtil.getFromEntity((ODataUri)requestContext.getUri(), (EntityDataModel)entityDataModel);
        if (fromEntityOption.isEmpty()) {
            throw new ODataBadRequestException("The URI of a " + requestContext.getRequest().getMethod() + " request to create a link must refer to a navigation property of a specific entity." + " This information could not be determined from the URI: " + requestContext.getRequest().getUri());
        }
        FromEntity fromEntity = (FromEntity)fromEntityOption.get();
        LOG.debug("fromEntity={}", (Object)fromEntity);
        String toEntityId = this.getToEntityId(requestContext);
        LOG.debug("toEntityId={}");
        try {
            toEntityKey = ODataUriUtil.getEntityKeyMap((ODataUri)this.uriParser.parseUri(toEntityId, entityDataModel), (EntityDataModel)entityDataModel);
        }
        catch (ODataUriParseException e1) {
            try {
                toEntityKey = ODataUriUtil.getEntityKeyMap((ResourcePath)this.uriParser.parseResourcePath(toEntityId, entityDataModel), (EntityDataModel)entityDataModel);
            }
            catch (ODataUriParseException e2) {
                throw new ODataBadRequestException("The id to the entity that is being linked to could not be determined from the request data: " + toEntityId);
            }
        }
        return new ODataLink(fromEntity.entityType(), fromEntity.navigationProperty(), fromEntity.entityKey(), toEntityKey);
    }
}

