/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.unmarshaller;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.Action;
import com.sdl.odata.api.edm.model.ActionImport;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.Parameter;
import com.sdl.odata.api.edm.model.Schema;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.util.ParameterTypeUtil;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.unmarshaller.ODataUnmarshallingException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class AbstractActionParser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActionParser.class);
    private ODataRequestContext requestContext;
    private EntityDataModel entityDataModel;
    private ODataUri odataUri;

    public AbstractActionParser(ODataRequestContext newRequestContext) {
        this.requestContext = ODataRendererUtils.checkNotNull(newRequestContext);
        this.entityDataModel = ODataRendererUtils.checkNotNull(this.requestContext.getEntityDataModel());
        this.odataUri = ODataRendererUtils.checkNotNull(this.requestContext.getUri());
    }

    public Object getAction() throws ODataException {
        Option actionNameOption = ODataUriUtil.getActionCallName((ODataUri)this.odataUri);
        if (actionNameOption.isDefined()) {
            LOG.debug("The operation is supposed to be an action");
            String actionName = (String)actionNameOption.get();
            return this.parseAction(actionName);
        }
        Option actionImportNameOption = ODataUriUtil.getActionImportCallName((ODataUri)this.odataUri);
        if (actionImportNameOption.isDefined()) {
            LOG.debug("The operation is supposed to be an action import");
            String actionImportName = (String)actionImportNameOption.get();
            return this.parseActionImport(actionImportName);
        }
        throw new ODataUnmarshallingException("Not able to parse action / action import");
    }

    private Object parseAction(String fullyQualifiedName) throws ODataException {
        Map<String, Object> bodyParameters;
        Object actionObject;
        int delimiterIndex = fullyQualifiedName.lastIndexOf(".");
        if (delimiterIndex < 0) {
            throw new ODataUnmarshallingException("The action should have a fully qualified name");
        }
        String namespace = fullyQualifiedName.substring(0, delimiterIndex);
        String actionSimpleName = fullyQualifiedName.substring(delimiterIndex + 1);
        Schema schema = ODataRendererUtils.checkNotNull(this.entityDataModel.getSchema(namespace), "There is no schema with name: {}", namespace);
        Action action = ODataRendererUtils.checkNotNull(schema.getAction(actionSimpleName), "There is no action {} within schema {}", actionSimpleName, namespace);
        try {
            actionObject = action.getJavaClass().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ODataUnmarshallingException("Error during instantiation of action: " + action.getName());
        }
        Set actionParameters = action.getParameters();
        try {
            bodyParameters = this.parseRequestBody(this.requestContext.getRequest().getBodyText("UTF-8"));
        }
        catch (IOException e) {
            throw new ODataUnmarshallingException("Error has occurred during parameter parsing");
        }
        this.assignParametersToAction(bodyParameters, actionParameters, actionObject);
        return actionObject;
    }

    public abstract Map<String, Object> parseRequestBody(String var1) throws IOException, ODataException;

    private void assignParametersToAction(Map<String, Object> bodyParameters, Set<Parameter> actionParameters, Object actionObject) throws ODataUnmarshallingException {
        for (Parameter parameter : actionParameters) {
            Object bodyParameter = bodyParameters.get(parameter.getName());
            if (bodyParameter == null && !parameter.isNullable()) {
                LOG.error("Error during setting a parameter to action object field");
                throw new ODataUnmarshallingException("Assigning null to non nullable parameter");
            }
            Field javaField = parameter.getJavaField();
            ParameterTypeUtil.setParameter((Object)actionObject, (Field)javaField, (Object)bodyParameter);
        }
    }

    private Object parseActionImport(String actionImportName) throws ODataException {
        Map<String, Object> bodyParameters;
        Object actionObject;
        ActionImport actionImport = ODataRendererUtils.checkNotNull(this.entityDataModel.getEntityContainer().getActionImport(actionImportName), "Not able to get the action import {} from entity container", actionImportName);
        Action action = actionImport.getAction();
        try {
            actionObject = action.getJavaClass().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ODataUnmarshallingException("Error during instantiation of action: " + action.getName());
        }
        Set actionParameters = action.getParameters();
        try {
            bodyParameters = this.parseRequestBody(this.requestContext.getRequest().getBodyText(Charset.forName("UTF-8").name()));
        }
        catch (IOException e) {
            throw new ODataUnmarshallingException("Error during request body parsing");
        }
        this.assignParametersToAction(bodyParameters, actionParameters, actionObject);
        return actionObject;
    }
}

