/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.xml.writer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.EntityContainer;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntitySet;
import com.sdl.odata.api.edm.model.Singleton;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.renderer.xml.util.XMLWriterUtil;
import com.sdl.odata.util.ReferenceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLServiceDocumentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(XMLServiceDocumentWriter.class);
    private static final String WORKSPACE = "workspace";
    private static final String ATOM = "atom";
    private static final String TITLE = "title";
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final String ODATA_SERVICE_NS = "http://www.w3.org/2007/app";
    private static final String SERVICE_BASE = "base";
    private static final String SERVICE = "service";
    private static final String SERVICE_COLLECTION = "collection";
    private static final String SERVICE_HREF = "href";
    private static final String SERVICE_SINGLETON = "singleton";
    private static final int BUFFER_SIZE = 1024;
    private final ODataUri oDataUri;
    private final EntityDataModel entityDataModel;

    public XMLServiceDocumentWriter(ODataUri uri, EntityDataModel entityDataModel) {
        this.oDataUri = ODataRendererUtils.checkNotNull(uri);
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buildServiceDocument() throws ODataRenderException {
        LOG.info("Building service(root) document");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);){
            XMLStreamWriter writer = this.startServiceDocument(outputStream);
            this.writeEntitySets(writer);
            this.writeSingleton(writer);
            this.endServiceDocument(writer);
            LOG.info("Successfully built service document");
            String string = outputStream.toString();
            return string;
        }
        catch (IOException | XMLStreamException e) {
            String msg = "Something went wrong when writing service document.";
            LOG.error(msg, (Throwable)e);
            throw new ODataRenderException(msg, (Throwable)e);
        }
    }

    private void writeSingleton(XMLStreamWriter writer) throws XMLStreamException, ODataRenderException {
        List singletons = this.getEntityContainer().getSingletons();
        LOG.debug("Number of singletons to be written in service document are {}", (Object)singletons.size());
        for (Singleton singleton : singletons) {
            this.writeElement(writer, "metadata", SERVICE_SINGLETON, "http://docs.oasis-open.org/odata/ns/metadata", singleton.getName(), singleton.getName());
        }
    }

    private void writeEntitySets(XMLStreamWriter writer) throws XMLStreamException, ODataRenderException {
        List entitySets = this.getEntityContainer().getEntitySets();
        LOG.debug("Number of entity sets to be written in service document are {}", (Object)entitySets.size());
        for (EntitySet entitySet : entitySets) {
            if (!entitySet.isIncludedInServiceDocument()) continue;
            this.writeElement(writer, null, SERVICE_COLLECTION, null, entitySet.getName(), entitySet.getName());
        }
    }

    private void writeElement(XMLStreamWriter writer, String prefix, String elementName, String nameSpaceURI, String hrefType, String title) throws XMLStreamException {
        if (ReferenceUtil.isNullOrEmpty((String)prefix)) {
            writer.writeStartElement(elementName);
        } else {
            writer.writeStartElement(prefix, elementName, nameSpaceURI);
        }
        writer.writeAttribute(SERVICE_HREF, hrefType);
        this.writeTitle(writer, title);
        writer.writeEndElement();
    }

    private XMLStreamWriter startServiceDocument(ByteArrayOutputStream outputStream) throws XMLStreamException, ODataRenderException {
        XMLStreamWriter writer = XMLWriterUtil.startDocument(outputStream, null, SERVICE, ODATA_SERVICE_NS);
        writer.writeNamespace(ATOM, ATOM_NS);
        writer.writeNamespace("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
        writer.writeNamespace(SERVICE_BASE, this.oDataUri.serviceRoot());
        writer.writeNamespace("context", ODataRendererUtils.getContextURL(this.oDataUri, this.entityDataModel));
        writer.writeStartElement(ODATA_SERVICE_NS, WORKSPACE);
        this.writeTitle(writer, this.getEntityContainer().getName());
        return writer;
    }

    private void endServiceDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        XMLWriterUtil.endDocument(writer);
    }

    private EntityContainer getEntityContainer() throws ODataRenderException {
        EntityContainer entityContainer = this.entityDataModel.getEntityContainer();
        if (entityContainer == null) {
            String message = "EntityContainer should not be null";
            LOG.error(message);
            throw new ODataRenderException(message);
        }
        return entityContainer;
    }

    private void writeTitle(XMLStreamWriter writer, String value) throws XMLStreamException {
        LOG.trace("atom:title value is {}", (Object)value);
        writer.writeStartElement(ATOM, TITLE, ATOM_NS);
        writer.writeCharacters(value);
        writer.writeEndElement();
    }
}

