/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.xml.writer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.renderer.AbstractPropertyWriter;
import com.sdl.odata.renderer.xml.util.XMLWriterUtil;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLPropertyWriter
extends AbstractPropertyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(XMLPropertyWriter.class);

    public XMLPropertyWriter(ODataUri uri, EntityDataModel entityDataModel) throws ODataRenderException {
        super(uri, entityDataModel);
    }

    @Override
    protected String generateNullPropertyString() throws ODataRenderException {
        LOG.debug("Given property value is null!!");
        return XMLWriterUtil.getNullPropertyXML("value", ODataRendererUtils.getContextURL(this.getODataUri(), this.getEntityDataModel()));
    }

    @Override
    protected String generatePrimitiveProperty(Object data, Type type) throws ODataRenderException {
        String context = ODataRendererUtils.getContextURL(this.getODataUri(), this.getEntityDataModel(), true);
        LOG.debug("Given data context is {}", (Object)context);
        return XMLWriterUtil.getPropertyXmlForPrimitives("value", type, data, context);
    }

    @Override
    protected String generateComplexProperty(Object data, StructuredType type) throws ODataException {
        return this.generateXMLForComplexProperty(data, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateXMLForComplexProperty(Object entity, StructuredType type) throws ODataException {
        LOG.debug("Complex property rendering started");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String typeFullyQualifiedName = type.getFullyQualifiedName();
            String context = ODataRendererUtils.getContextURL(this.getODataUri(), this.getEntityDataModel());
            LOG.debug("Context for complex property is {}", (Object)context);
            XMLStreamWriter writer = XMLWriterUtil.startElement(outputStream, "value", "#" + typeFullyQualifiedName, context, true);
            this.handleCollectionAndComplexProperties(entity, type, writer);
            XMLWriterUtil.endElement(writer);
            String string = outputStream.toString();
            return string;
        }
        catch (IOException | XMLStreamException e) {
            throw new ODataRenderException("Error while rendering complex property value.", (Throwable)e);
        }
    }

    private void handleCollectionAndComplexProperties(Object entity, StructuredType type, XMLStreamWriter writer) throws XMLStreamException, ODataRenderException {
        if (this.isCollection(entity)) {
            LOG.debug("Given property is collection of complex values");
            for (Object obj : (List)entity) {
                writer.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "element");
                this.writeAllProperties(obj, type, writer);
                writer.writeEndElement();
            }
        } else {
            LOG.debug("Given property is single complex value");
            this.writeAllProperties(entity, type, writer);
        }
    }

    private void writeAllProperties(Object entity, StructuredType type, XMLStreamWriter writer) throws ODataRenderException {
        EntityDataModelUtil.visitProperties((EntityDataModel)this.getEntityDataModel(), (StructuredType)type, property -> {
            try {
                if (!(property instanceof NavigationProperty)) {
                    this.handleProperty(entity, property, writer);
                }
            }
            catch (ODataException | IllegalAccessException | XMLStreamException e) {
                throw new ODataRenderException("Error while writing property: " + property.getName(), e);
            }
        });
    }

    private void handleProperty(Object entity, StructuralProperty property, XMLStreamWriter writer) throws IllegalAccessException, XMLStreamException, ODataException {
        Field field = property.getJavaField();
        field.setAccessible(true);
        Object value = field.get(entity);
        LOG.trace("Property name is '{}' and its value is '{}'", (Object)property.getName(), value);
        Type type = this.getType(value);
        if (type == null) {
            String msg = String.format("Field type %s is not found in entity data model", field.getType());
            LOG.error(msg);
            throw new ODataRenderException(msg);
        }
        switch (type.getMetaType()) {
            case PRIMITIVE: {
                this.handleCollectionsAndPrimitiveProperties(writer, property.getName(), value);
                break;
            }
            case COMPLEX: {
                writer.writeStartElement(property.getName());
                this.handleCollectionAndComplexProperties(value, (StructuredType)type, writer);
                writer.writeEndElement();
                break;
            }
            default: {
                this.defaultHandling(type);
            }
        }
    }

    private void handleCollectionsAndPrimitiveProperties(XMLStreamWriter writer, String name, Object value) throws XMLStreamException {
        if (this.isCollection(value)) {
            XMLWriterUtil.writePrimitiveCollection(writer, name, (List)value);
        } else if (value == null) {
            XMLWriterUtil.writeElementWithNull(writer, name);
        } else {
            XMLWriterUtil.writePrimitiveElement(writer, name, value);
        }
    }
}

