/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.xml.writer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.renderer.ODataRenderException;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLErrorResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(XMLErrorResponseWriter.class);
    private final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private XMLStreamWriter xmlWriter = null;
    private ByteArrayOutputStream outputStream = null;

    public void startDocument() throws ODataRenderException {
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.xmlWriter = this.xmlOutputFactory.createXMLStreamWriter(this.outputStream, StandardCharsets.UTF_8.name());
            this.xmlWriter.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            this.xmlWriter.setPrefix("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to start stream XML");
            throw new ODataRenderException("Not possible to start stream XML: ", (Throwable)e);
        }
    }

    public void endDocument() throws ODataRenderException {
        try {
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to end stream XML");
            throw new ODataRenderException("Not possible to end stream XML: ", (Throwable)e);
        }
    }

    public void writeError(ODataException exception) throws ODataRenderException {
        ODataRendererUtils.checkNotNull(exception);
        try {
            this.xmlWriter.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "error");
            this.xmlWriter.writeNamespace("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
            this.xmlWriter.writeStartElement("metadata", "code", "http://docs.oasis-open.org/odata/ns/metadata");
            this.xmlWriter.writeCharacters(String.valueOf(exception.getCode().getCode()));
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeStartElement("metadata", "message", "http://docs.oasis-open.org/odata/ns/metadata");
            this.xmlWriter.writeCharacters(String.valueOf(exception.getMessage()));
            this.xmlWriter.writeEndElement();
            if (exception.getTarget() != null) {
                this.xmlWriter.writeStartElement("metadata", "target", "http://docs.oasis-open.org/odata/ns/metadata");
                this.xmlWriter.writeCharacters(String.valueOf(exception.getTarget()));
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to marshall error stream XML");
            throw new ODataRenderException("Not possible to marshall error stream XML: ", (Throwable)e);
        }
    }

    public String getXml() {
        return this.outputStream.toString();
    }
}

