/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.xml.util;

import com.sdl.odata.api.edm.model.PrimitiveType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.util.ReferenceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLWriterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XMLWriterUtil.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();

    private XMLWriterUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPropertyXmlForPrimitives(String rootName, Type type, Object data, String context) throws ODataRenderException {
        LOG.debug("PropertyXMLForPrimitives invoked with {}, {}, {}", new Object[]{rootName, type, data});
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            XMLStreamWriter writer = XMLWriterUtil.startElement(outputStream, rootName, type.getName(), context, false);
            if (data instanceof List) {
                XMLWriterUtil.writeMultipleElementsForPrimitives(writer, (List)data);
            } else {
                writer.writeCharacters(data.toString());
            }
            XMLWriterUtil.endElement(writer);
            String string = outputStream.toString();
            return string;
        }
        catch (IOException | XMLStreamException e) {
            throw new ODataRenderException("Error while rendering primitive property value.", (Throwable)e);
        }
    }

    public static XMLStreamWriter startDocument(ByteArrayOutputStream outputStream, String prefix, String documentRootName, String nameSpaceURI) throws XMLStreamException {
        XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream, StandardCharsets.UTF_8.name());
        if (ReferenceUtil.isNullOrEmpty((String)prefix)) {
            writer.writeStartElement(documentRootName);
            writer.setDefaultNamespace(nameSpaceURI);
            writer.writeDefaultNamespace(nameSpaceURI);
        } else {
            writer.writeStartElement(prefix, documentRootName, nameSpaceURI);
            writer.writeNamespace(prefix, nameSpaceURI);
        }
        return writer;
    }

    public static void endDocument(XMLStreamWriter writer) throws XMLStreamException {
        XMLWriterUtil.endElement(writer);
        writer.close();
    }

    public static XMLStreamWriter startElement(ByteArrayOutputStream outputStream, String rootName, String typeName, String context, boolean defaultNameSpace) throws XMLStreamException {
        XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream, "UTF-8");
        writer.writeStartElement("metadata", rootName, "http://docs.oasis-open.org/odata/ns/metadata");
        if (defaultNameSpace) {
            LOG.debug("Starting {} element with default data namespace", (Object)rootName);
            writer.setDefaultNamespace("http://docs.oasis-open.org/odata/ns/data");
            writer.writeDefaultNamespace("http://docs.oasis-open.org/odata/ns/data");
        } else {
            LOG.debug("Starting {} element without default namespaces", (Object)rootName);
            writer.writeNamespace("data", "http://docs.oasis-open.org/odata/ns/data");
        }
        writer.writeNamespace("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
        writer.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "context", context);
        if (!PrimitiveType.STRING.getName().equals(typeName)) {
            writer.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "type", typeName);
        }
        return writer;
    }

    public static void writePrimitiveElement(XMLStreamWriter writer, String nodeName, Object nodeValue) throws XMLStreamException {
        LOG.trace("Field name is {}, field value is {}", (Object)nodeName, nodeValue);
        writer.writeStartElement(nodeName);
        writer.writeCharacters(nodeValue.toString());
        writer.writeEndElement();
    }

    public static void writePrimitiveCollection(XMLStreamWriter writer, String nodeName, List values) throws XMLStreamException {
        LOG.trace("Field name is {}, field value is {}", (Object)nodeName, (Object)values);
        writer.writeStartElement(nodeName);
        for (Object object : values) {
            writer.writeStartElement("http://docs.oasis-open.org/odata/ns/metadata", "element");
            writer.writeCharacters(object.toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeElementWithNull(XMLStreamWriter writer, String nodeName) throws XMLStreamException {
        LOG.debug("Field {} with value null", (Object)nodeName);
        writer.writeStartElement(nodeName);
        writer.writeAttribute("null", "true");
        writer.writeEndElement();
    }

    public static void endElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getNullPropertyXML(String rootName, String context) throws ODataRenderException {
        LOG.debug("NullPropertyXML invoked with {}", (Object)rootName);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartElement("metadata", rootName, "http://docs.oasis-open.org/odata/ns/metadata");
            writer.writeNamespace("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
            writer.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "context", context);
            writer.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "null", "true");
            XMLWriterUtil.endElement(writer);
            String string = outputStream.toString();
            return string;
        }
        catch (IOException | XMLStreamException e) {
            throw new ODataRenderException("Error while rendering null property.", (Throwable)e);
        }
    }

    private static void writeMultipleElementsForPrimitives(XMLStreamWriter writer, List<?> list) throws XMLStreamException {
        for (Object obj : list) {
            writer.writeStartElement("metadata", "element", "http://docs.oasis-open.org/odata/ns/metadata");
            writer.writeCharacters(obj.toString());
            writer.writeEndElement();
        }
    }
}

