/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.xml;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractAtomRenderer;
import com.sdl.odata.renderer.xml.writer.XMLPropertyWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class XMLValueRenderer
extends AbstractAtomRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(XMLValueRenderer.class);
    private static final int DEFAULT_OPERATION_SCORE = 50;

    @Override
    public int score(ODataRequestContext requestContext, Object data) {
        if (!this.isNonEntityQuery(requestContext.getUri(), requestContext.getEntityDataModel())) {
            return 0;
        }
        int operationScore = 0;
        if (ODataUriUtil.isFunctionCallUri((ODataUri)requestContext.getUri()) || ODataUriUtil.isActionCallUri((ODataUri)requestContext.getUri())) {
            operationScore = 50;
        }
        int returnScore = Math.max(super.score(requestContext, data), operationScore);
        LOG.debug("Renderer score is {}", (Object)returnScore);
        return returnScore;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering property for request: {}", (Object)requestContext);
        XMLPropertyWriter propertyWriter = new XMLPropertyWriter(requestContext.getUri(), requestContext.getEntityDataModel());
        String response = propertyWriter.getPropertyAsString(data);
        LOG.debug("Response property xml is {}", (Object)response);
        try {
            responseBuilder.setContentType(MediaType.XML).setBodyText(response, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("End rendering property for request: {}", (Object)requestContext);
    }
}

