/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.xml;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.metadata.ServiceDocumentRenderer;
import com.sdl.odata.renderer.xml.writer.XMLServiceDocumentWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XMLServiceDocumentRenderer
extends ServiceDocumentRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(XMLServiceDocumentRenderer.class);

    public int score(ODataRequestContext requestContext, Object data) {
        int score = super.scoreServiceDocument(requestContext, MediaType.XML);
        if (this.shouldBeDefaultToXML(requestContext.getUri(), score)) {
            ++score;
        }
        LOG.debug("Score of XML service document renderer is {}", (Object)score);
        return score;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering service document for request: {}", (Object)requestContext);
        XMLServiceDocumentWriter writer = new XMLServiceDocumentWriter(requestContext.getUri(), requestContext.getEntityDataModel());
        String serviceDocument = writer.buildServiceDocument();
        try {
            responseBuilder.setContentType(MediaType.XML).setHeader("OData-Version", "4.0").setBodyText(serviceDocument, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("End rendering service document for request: {}", (Object)requestContext);
    }

    private boolean shouldBeDefaultToXML(ODataUri uri, int score) {
        return this.isServiceDocument(uri) && (score == 30 || score == 0);
    }
}

