/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.xml;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractRenderer;
import com.sdl.odata.renderer.xml.writer.XMLErrorResponseWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XMLErrorResponseRenderer
extends AbstractRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(XMLErrorResponseRenderer.class);

    public int score(ODataRequestContext requestContext, Object data) {
        int atomXmlContentTypeScore;
        int xmlContentTypeScore;
        int totalContentTypeScore;
        int xmlAcceptScore;
        if (data == null || !(data instanceof ODataException)) {
            return 0;
        }
        List accept = requestContext.getRequest().getAccept();
        int atomXmlAcceptScore = this.scoreByMediaType(accept, MediaType.ATOM_XML);
        int totalAcceptScore = Math.max(atomXmlAcceptScore, xmlAcceptScore = this.scoreByMediaType(accept, MediaType.XML));
        int totalScore = Math.max(totalAcceptScore, totalContentTypeScore = Math.max(xmlContentTypeScore = this.scoreByContentType(requestContext, MediaType.XML), atomXmlContentTypeScore = this.scoreByContentType(requestContext, MediaType.ATOM_XML)));
        if (totalScore == 30 || totalScore == 0) {
            ++totalScore;
        }
        return totalScore > 0 ? totalScore + 100 : 0;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering error response for request: {}", (Object)requestContext);
        XMLErrorResponseWriter writer = new XMLErrorResponseWriter();
        writer.startDocument();
        writer.writeError((ODataException)((Object)data));
        writer.endDocument();
        try {
            responseBuilder.setContentType(MediaType.XML).setHeader("OData-Version", "4.0").setHeader("Content-Language", Locale.ENGLISH.getLanguage()).setBodyText(writer.getXml(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("End rendering error response for request: {}", (Object)requestContext);
    }
}

