/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.metadata;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.ComplexType;
import com.sdl.odata.api.edm.model.EntityContainer;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntitySet;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.EnumType;
import com.sdl.odata.api.edm.model.Schema;
import com.sdl.odata.api.edm.model.Singleton;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.renderer.metadata.MetadataDocumentComplexTypeWriter;
import com.sdl.odata.renderer.metadata.MetadataDocumentEntitySetWriter;
import com.sdl.odata.renderer.metadata.MetadataDocumentEntityTypeWriter;
import com.sdl.odata.renderer.metadata.MetadataDocumentEnumTypeWriter;
import com.sdl.odata.renderer.metadata.MetadataDocumentSingletonWriter;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDocumentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentWriter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private XMLStreamWriter xmlWriter = null;
    private ByteArrayOutputStream outputStream = null;
    private MetadataDocumentEntityTypeWriter entityTypeWriter = null;
    private MetadataDocumentComplexTypeWriter complexTypeWriter = null;
    private MetadataDocumentEnumTypeWriter enumTypeWriter = null;
    private MetadataDocumentEntitySetWriter entitySetWriter = null;
    private MetadataDocumentSingletonWriter singletonWriter = null;
    private final EntityDataModel entityDataModel;

    public MetadataDocumentWriter(EntityDataModel entityDataModel) {
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
    }

    public void startDocument() throws ODataRenderException {
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.xmlWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(this.outputStream, StandardCharsets.UTF_8.name());
            this.entityTypeWriter = new MetadataDocumentEntityTypeWriter(this.xmlWriter, this.entityDataModel);
            this.complexTypeWriter = new MetadataDocumentComplexTypeWriter(this.xmlWriter, this.entityDataModel);
            this.enumTypeWriter = new MetadataDocumentEnumTypeWriter(this.xmlWriter);
            this.entitySetWriter = new MetadataDocumentEntitySetWriter(this.xmlWriter);
            this.singletonWriter = new MetadataDocumentSingletonWriter(this.xmlWriter);
            this.xmlWriter.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            this.xmlWriter.setPrefix("edmx", "http://docs.oasis-open.org/odata/ns/edmx");
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to start stream XML");
            throw new ODataRenderException("Not possible to start stream XML: ", (Throwable)e);
        }
    }

    public void endDocument() throws ODataRenderException {
        try {
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to end stream XML");
            throw new ODataRenderException("Not possible to end stream XML: ", (Throwable)e);
        }
    }

    public void writeMetadataDocument() throws ODataRenderException {
        try {
            this.xmlWriter.writeStartElement("http://docs.oasis-open.org/odata/ns/edmx", "Edmx");
            this.xmlWriter.writeNamespace("edmx", "http://docs.oasis-open.org/odata/ns/edmx");
            this.xmlWriter.writeAttribute("Version", "4.0");
            this.xmlWriter.writeStartElement("http://docs.oasis-open.org/odata/ns/edmx", "DataServices");
            boolean entityContinerWritten = false;
            for (Schema schema : this.entityDataModel.getSchemas()) {
                this.xmlWriter.writeStartElement("Schema");
                this.xmlWriter.writeDefaultNamespace("http://docs.oasis-open.org/odata/ns/edm");
                this.xmlWriter.writeAttribute("Namespace", schema.getNamespace());
                block8: for (Type type : schema.getTypes()) {
                    switch (type.getMetaType()) {
                        case ENTITY: {
                            this.entityTypeWriter.write((EntityType)type);
                            continue block8;
                        }
                        case COMPLEX: {
                            this.complexTypeWriter.write((ComplexType)type);
                            continue block8;
                        }
                        case ENUM: {
                            this.enumTypeWriter.write((EnumType)type);
                            continue block8;
                        }
                    }
                    LOG.error("Unexpected type: {}", (Object)type.getFullyQualifiedName());
                    throw new ODataRenderException("Unexpected type: " + type.getFullyQualifiedName());
                }
                if (!entityContinerWritten) {
                    this.writeEntityContainer(this.entityDataModel.getEntityContainer());
                    entityContinerWritten = true;
                }
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to start stream XML");
            throw new ODataRenderException("Not possible to start stream XML: ", (Throwable)e);
        }
    }

    private void writeEntityContainer(EntityContainer entityContainer) throws XMLStreamException {
        this.xmlWriter.writeStartElement("EntityContainer");
        this.xmlWriter.writeAttribute("Name", entityContainer.getName());
        for (EntitySet entitySet : entityContainer.getEntitySets()) {
            this.entitySetWriter.write(entitySet);
        }
        for (Singleton singleton : entityContainer.getSingletons()) {
            this.singletonWriter.write(singleton);
        }
        this.xmlWriter.writeEndElement();
    }

    public String getXml() {
        return this.outputStream.toString();
    }
}

