/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.metadata;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.NavigationPropertyBinding;
import com.sdl.odata.api.edm.model.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDocumentSingletonWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentSingletonWriter.class);
    private final XMLStreamWriter xmlWriter;

    public MetadataDocumentSingletonWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = ODataRendererUtils.checkNotNull(xmlWriter);
    }

    public void write(Singleton singleton) throws XMLStreamException {
        LOG.debug("Writing singleton {} of type {}", (Object)singleton.getName(), (Object)singleton.getTypeName());
        this.xmlWriter.writeStartElement("Singleton");
        this.xmlWriter.writeAttribute("Name", singleton.getName());
        this.xmlWriter.writeAttribute("Type", singleton.getTypeName());
        for (NavigationPropertyBinding navPropertyBinding : singleton.getNavigationPropertyBindings()) {
            this.xmlWriter.writeStartElement("NavigationPropertyBinding");
            this.xmlWriter.writeAttribute("Path", navPropertyBinding.getPath());
            this.xmlWriter.writeAttribute("Target", navPropertyBinding.getTarget());
            this.xmlWriter.writeEndElement();
        }
        this.xmlWriter.writeEndElement();
    }
}

