/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.metadata;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.parser.MetadataUri;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractRenderer;
import com.sdl.odata.renderer.metadata.MetadataDocumentWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class MetadataDocumentRenderer
extends AbstractRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentRenderer.class);
    public static final int MAX = 100;
    private static final String ODATA_VERSION_HEADER = "4.0";

    public int score(ODataRequestContext requestContext, Object data) {
        ODataUri uri = requestContext.getUri();
        return uri != null && uri.relativeUri() instanceof MetadataUri ? 100 : 0;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering $metadata document for request: {}", (Object)requestContext);
        MetadataDocumentWriter writer = new MetadataDocumentWriter(requestContext.getEntityDataModel());
        writer.startDocument();
        writer.writeMetadataDocument();
        writer.endDocument();
        try {
            responseBuilder.setStatus(ODataResponse.Status.OK).setContentType(MediaType.XML).setHeader("OData-Version", ODATA_VERSION_HEADER).setBodyText(writer.getXml(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("End rendering $metadata document for request: {}", (Object)requestContext);
    }
}

