/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.metadata;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.util.ReferenceUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDocumentPropertyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentPropertyWriter.class);
    private final XMLStreamWriter xmlWriter;

    public MetadataDocumentPropertyWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = ODataRendererUtils.checkNotNull(xmlWriter);
    }

    public void write(StructuralProperty property) throws XMLStreamException {
        LOG.debug("Writing property {} of type {}", (Object)property.getName(), (Object)property.getTypeName());
        if (property instanceof NavigationProperty) {
            NavigationProperty navProperty = (NavigationProperty)property;
            this.xmlWriter.writeStartElement("NavigationProperty");
            this.writeCommonPropertyAttributes(property);
            if (!ReferenceUtil.isNullOrEmpty((String)navProperty.getPartnerName())) {
                this.xmlWriter.writeAttribute("Partner", navProperty.getPartnerName());
            }
            this.xmlWriter.writeEndElement();
        } else {
            this.xmlWriter.writeStartElement("Property");
            this.writeCommonPropertyAttributes(property);
            this.xmlWriter.writeEndElement();
        }
    }

    private void writeCommonPropertyAttributes(StructuralProperty property) throws XMLStreamException {
        this.xmlWriter.writeAttribute("Name", property.getName());
        this.xmlWriter.writeAttribute("Type", property.getTypeName());
        this.xmlWriter.writeAttribute("Nullable", Boolean.toString(property.isNullable()));
    }
}

