/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.metadata;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.EnumMember;
import com.sdl.odata.api.edm.model.EnumType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDocumentEnumTypeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentEnumTypeWriter.class);
    private final XMLStreamWriter xmlWriter;

    public MetadataDocumentEnumTypeWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = ODataRendererUtils.checkNotNull(xmlWriter);
    }

    public void write(EnumType type) throws XMLStreamException {
        LOG.debug("Writing type {} of type {}", (Object)type.getName(), (Object)type.getMetaType());
        this.xmlWriter.writeStartElement("EnumType");
        this.xmlWriter.writeAttribute("Name", type.getName());
        for (EnumMember member : type.getMembers()) {
            this.xmlWriter.writeStartElement("Member");
            this.xmlWriter.writeAttribute("Name", member.getName());
            this.xmlWriter.writeEndElement();
        }
        this.xmlWriter.writeEndElement();
    }
}

