/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.metadata;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.PropertyRef;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.renderer.metadata.MetadataDocumentPropertyWriter;
import com.sdl.odata.util.ReferenceUtil;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDocumentEntityTypeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentEntityTypeWriter.class);
    private final XMLStreamWriter xmlWriter;
    private final MetadataDocumentPropertyWriter propertyWriter;
    private EntityDataModel entityDataModel;

    public MetadataDocumentEntityTypeWriter(XMLStreamWriter xmlWriter, EntityDataModel entityDataModel) {
        this.xmlWriter = ODataRendererUtils.checkNotNull(xmlWriter);
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
        this.propertyWriter = new MetadataDocumentPropertyWriter(xmlWriter);
    }

    public void write(EntityType type) throws ODataRenderException {
        LOG.debug("Writing type {} of type {}", (Object)type.getName(), (Object)type.getMetaType());
        try {
            this.xmlWriter.writeStartElement("EntityType");
            if (!ReferenceUtil.isNullOrEmpty((String)type.getBaseTypeName())) {
                this.xmlWriter.writeAttribute("BaseType", type.getBaseTypeName());
            }
            if (type.isOpen()) {
                this.xmlWriter.writeAttribute("OpenType", Boolean.toString(type.isOpen()));
            }
            if (type.hasStream()) {
                this.xmlWriter.writeAttribute("HasStream", Boolean.toString(type.hasStream()));
            }
            this.xmlWriter.writeAttribute("Name", type.getName());
            if (type.isAbstract()) {
                this.xmlWriter.writeAttribute("Abstract", "true");
            }
            this.xmlWriter.writeStartElement("Key");
            for (PropertyRef propertyRef : type.getKey().getPropertyRefs()) {
                this.xmlWriter.writeStartElement("PropertyRef");
                this.xmlWriter.writeAttribute("Name", propertyRef.getPath());
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
            EntityDataModelUtil.visitProperties((EntityDataModel)this.entityDataModel, (StructuredType)type, property -> {
                try {
                    this.propertyWriter.write(property);
                }
                catch (XMLStreamException e) {
                    throw new ODataRenderException("Error while writing property: " + property.getName(), (Throwable)e);
                }
            });
            this.xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new ODataRenderException("Error while writing entity type: " + type.getName(), (Throwable)e);
        }
    }
}

