/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.metadata;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.EntitySet;
import com.sdl.odata.api.edm.model.NavigationPropertyBinding;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDocumentEntitySetWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDocumentEntitySetWriter.class);
    private final XMLStreamWriter xmlWriter;

    public MetadataDocumentEntitySetWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = ODataRendererUtils.checkNotNull(xmlWriter);
    }

    public void write(EntitySet entitySet) throws XMLStreamException {
        LOG.debug("Writing entity set {} of type {}", (Object)entitySet.getName(), (Object)entitySet.getTypeName());
        this.xmlWriter.writeStartElement("EntitySet");
        this.xmlWriter.writeAttribute("Name", entitySet.getName());
        this.xmlWriter.writeAttribute("EntityType", entitySet.getTypeName());
        for (NavigationPropertyBinding navPropertyBinding : entitySet.getNavigationPropertyBindings()) {
            this.xmlWriter.writeStartElement("NavigationPropertyBinding");
            this.xmlWriter.writeAttribute("Path", navPropertyBinding.getPath());
            this.xmlWriter.writeAttribute("Target", navPropertyBinding.getTarget());
            this.xmlWriter.writeEndElement();
        }
        this.xmlWriter.writeEndElement();
    }
}

