/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json.writer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntitySet;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.EnumType;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.PrimitiveType;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.edm.model.TypeDefinition;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.renderer.json.util.JsonWriterUtil;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.List;

public class JsonWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonWriter.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private JsonGenerator jsonGenerator;
    private final ODataUri odataUri;
    private final EntityDataModel entityDataModel;
    private EntitySet entitySet;
    private java.util.List<String> expandedProperties = new ArrayList<String>();
    private String contextURL = null;

    public JsonWriter(ODataUri oDataUri, EntityDataModel entityDataModel) {
        this.odataUri = ODataRendererUtils.checkNotNull(oDataUri);
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
        this.expandedProperties.addAll(ODataUriUtil.asJavaList((List)ODataUriUtil.getSimpleExpandPropertyNames((ODataUri)oDataUri)));
    }

    public String writeFeed(java.util.List<?> entities, String contextUrl) throws ODataRenderException {
        String json;
        this.contextURL = ODataRendererUtils.checkNotNull(contextUrl);
        try {
            json = this.writeJson(entities);
        }
        catch (ODataEdmException | ODataRenderException | IOException | IllegalAccessException | NoSuchFieldException e) {
            LOG.error("Not possible to marshall feed stream JSON");
            throw new ODataRenderException("Not possible to marshall feed stream JSON: ", e);
        }
        return json;
    }

    public String writeEntry(Object entity, String contextUrl) throws ODataRenderException {
        String json;
        this.contextURL = ODataRendererUtils.checkNotNull(contextUrl);
        try {
            json = this.writeJson(entity);
        }
        catch (ODataEdmException | ODataRenderException | IOException | IllegalAccessException | NoSuchFieldException e) {
            LOG.error("Not possible to marshall single entity stream JSON");
            throw new ODataRenderException("Not possible to marshall single entity stream JSON: ", e);
        }
        return json;
    }

    private String writeJson(Object data) throws IOException, NoSuchFieldException, IllegalAccessException, ODataEdmException, ODataRenderException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.jsonGenerator = JSON_FACTORY.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
        this.jsonGenerator.writeStartObject();
        this.entitySet = data instanceof java.util.List ? this.getEntitySet((java.util.List)data) : this.getEntitySet(data);
        this.jsonGenerator.writeStringField("@odata.context", this.contextURL);
        if (!(data instanceof java.util.List)) {
            if (this.entitySet != null) {
                this.jsonGenerator.writeStringField("@odata.id", String.format("%s(%s)", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)data), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, (Object)data)));
            } else {
                this.jsonGenerator.writeStringField("@odata.id", String.format("%s", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)data)));
            }
        }
        if (data instanceof java.util.List) {
            this.marshallEntities((java.util.List)data);
        } else {
            this.marshall(data, this.entityDataModel.getType(data.getClass()));
        }
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.close();
        return stream.toString();
    }

    private void marshallEntities(java.util.List<?> entities) throws IOException, ODataRenderException, ODataEdmException, NoSuchFieldException, IllegalAccessException {
        this.jsonGenerator.writeArrayFieldStart("value");
        for (Object entity : entities) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("@odata.id", String.format("%s(%s)", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, entity), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, entity)));
            this.marshall(entity, this.entityDataModel.getType(entity.getClass()));
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void marshall(Object object, Type type) throws IOException, ODataRenderException, NoSuchFieldException, IllegalAccessException {
        switch (type.getMetaType()) {
            case ABSTRACT: {
                throw new UnsupportedOperationException("Marshalling abstract OData types is not supported");
            }
            case PRIMITIVE: {
                this.marshallPrimitive(object, (PrimitiveType)type);
                break;
            }
            case ENTITY: 
            case COMPLEX: {
                this.marshallStructured(object, (StructuredType)type);
                break;
            }
            case ENUM: {
                this.marshallEnum(object, (EnumType)type);
                break;
            }
            case TYPE_DEFINITION: {
                this.marshallPrimitive(object, ((TypeDefinition)type).getUnderlyingType());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + type);
            }
        }
    }

    private void marshallPrimitive(Object value, PrimitiveType primitiveType) throws IOException {
        LOG.debug("Primitive value: {} of type: {}", value, (Object)primitiveType);
        if (value != null) {
            JsonWriterUtil.writePrimitiveValue(value, this.jsonGenerator);
        } else {
            this.jsonGenerator.writeNull();
        }
    }

    private void marshallStructured(Object object, StructuredType structuredType) throws ODataRenderException, IOException, NoSuchFieldException, IllegalAccessException {
        LOG.debug("Start structured value of type: {}", (Object)structuredType);
        if (object != null) {
            this.writeODataType(structuredType);
            EntityDataModelUtil.visitProperties((EntityDataModel)this.entityDataModel, (StructuredType)structuredType, property -> {
                try {
                    if (property instanceof NavigationProperty) {
                        Object value;
                        LOG.debug("Start marshalling navigation property: {}", (Object)property.getName());
                        NavigationProperty navProperty = (NavigationProperty)property;
                        if (this.isExpandedProperty(navProperty) && (value = this.getValueFromProperty(object, navProperty)) != null) {
                            if (navProperty.isCollection()) {
                                this.jsonGenerator.writeArrayFieldStart(navProperty.getName());
                                for (Object propertyValue : (Collection)value) {
                                    this.jsonGenerator.writeStartObject();
                                    this.marshall(propertyValue, this.entityDataModel.getType(propertyValue.getClass()));
                                    this.jsonGenerator.writeEndObject();
                                }
                                this.jsonGenerator.writeEndArray();
                            } else {
                                this.jsonGenerator.writeObjectFieldStart(navProperty.getName());
                                this.marshall(value, this.entityDataModel.getType(value.getClass()));
                                this.jsonGenerator.writeEndObject();
                            }
                        }
                        LOG.debug("Navigation property: {} marshalled", (Object)property.getName());
                    } else {
                        LOG.debug("Started marshalling property: {}", (Object)property.getName());
                        this.marshallStructuralProperty(object, property);
                        LOG.debug("Property: {} marshalled", (Object)property.getName());
                    }
                }
                catch (IOException | IllegalAccessException | NoSuchFieldException e) {
                    throw new ODataRenderException("Error while writing property: " + property.getName(), (Throwable)e);
                }
            });
        } else {
            this.jsonGenerator.writeNull();
            LOG.debug("Structured value is null");
        }
        LOG.debug("End structured value of type: {}", (Object)structuredType);
    }

    private void writeODataType(StructuredType structuredType) throws IOException {
        if (this.entitySet != null) {
            String typeName = this.entitySet.getTypeName();
            String type = typeName.substring(typeName.lastIndexOf(".") + 1, typeName.length());
            if (!type.equals(structuredType.getName())) {
                this.jsonGenerator.writeStringField("@odata.type", String.format("#%s.%s", structuredType.getNamespace(), structuredType.getName()));
            } else {
                LOG.debug("{} has root level. {} won't be written here", (Object)this.entitySet.getName(), (Object)"@odata.type");
            }
        }
    }

    private void marshallStructuralProperty(Object object, StructuralProperty property) throws ODataRenderException, IOException, NoSuchFieldException, IllegalAccessException {
        Object propertyValue;
        String propertyName = property.getName();
        Field field = property.getJavaField();
        try {
            field.setAccessible(true);
            propertyValue = field.get(object);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error getting field value of field: " + field.toGenericString());
            throw new ODataRenderException("Error getting field value of field: " + field.toGenericString());
        }
        if (propertyValue == null) {
            if (property.isCollection()) {
                throw new ODataRenderException("Collection property has null value: " + property);
            }
            if (!property.isNullable()) {
                throw new ODataRenderException("Non-nullable property has null value: " + property);
            }
        }
        if (property.isCollection()) {
            Iterator<Object> iterator;
            if (propertyValue.getClass().isArray()) {
                iterator = Arrays.asList((Object[])propertyValue).iterator();
            } else if (Collection.class.isAssignableFrom(propertyValue.getClass())) {
                iterator = ((Collection)propertyValue).iterator();
            } else {
                throw new UnsupportedOperationException("Unsupported collection type: " + propertyValue.getClass().getName() + " for property: " + propertyName);
            }
            Type elementType = this.entityDataModel.getType(property.getElementTypeName());
            if (elementType == null) {
                throw new ODataRenderException("OData type not found for elements of property: " + property);
            }
            LOG.debug("Start collection property: {}", (Object)propertyName);
            if (((Collection)propertyValue).isEmpty()) {
                this.jsonGenerator.writeArrayFieldStart(propertyName);
                this.jsonGenerator.writeEndArray();
            } else {
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (element instanceof Number | element instanceof String | element.getClass().isEnum()) {
                        this.marshallToArray(propertyName, element, iterator);
                        continue;
                    }
                    this.marshallCollection(propertyName, iterator, element, elementType);
                }
            }
            LOG.debug("End collection property: {}", (Object)propertyName);
        } else {
            LOG.debug("Start property: {}", (Object)propertyName);
            Type propertyType = this.entityDataModel.getType(property.getTypeName());
            if (propertyType == null) {
                throw new ODataRenderException("OData type not found for property: " + property);
            }
            this.jsonGenerator.writeFieldName(propertyName);
            if (propertyType.getMetaType().equals((Object)MetaType.COMPLEX) && propertyValue != null) {
                this.jsonGenerator.writeStartObject();
            }
            this.marshall(propertyValue, propertyType);
            if (propertyType.getMetaType().equals((Object)MetaType.COMPLEX) && propertyValue != null) {
                this.jsonGenerator.writeEndObject();
            }
            LOG.debug("End property: {}", (Object)propertyName);
        }
    }

    private void marshallCollection(String propertyName, Iterator<?> iterator, Object first, Type elementType) throws IOException, ODataRenderException, NoSuchFieldException, IllegalAccessException {
        this.jsonGenerator.writeArrayFieldStart(propertyName);
        this.jsonGenerator.writeStartObject();
        this.marshall(first, elementType);
        this.jsonGenerator.writeEndObject();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.jsonGenerator.writeStartObject();
            this.marshall(element, elementType);
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void marshallToArray(String propertyName, Object first, Iterator<?> iterator) throws IOException {
        this.jsonGenerator.writeArrayFieldStart(propertyName);
        this.jsonGenerator.writeObject((Object)first.toString());
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.jsonGenerator.writeObject((Object)element.toString());
        }
        this.jsonGenerator.writeEndArray();
    }

    private void marshallEnum(Object value, EnumType enumType) throws IOException {
        LOG.debug("Enum value: {} of type: {}", value, (Object)enumType);
        this.jsonGenerator.writeString(value.toString());
    }

    private boolean isExpandedProperty(NavigationProperty property) {
        return this.expandedProperties.contains(property.getName());
    }

    private Object getValueFromProperty(Object entity, NavigationProperty property) throws NoSuchFieldException, IllegalAccessException {
        Field propertyField = property.getJavaField();
        propertyField.setAccessible(true);
        return propertyField.get(entity);
    }

    private EntitySet getEntitySet(Object entity) {
        String entityTypeName = this.getEntityType(entity).getFullyQualifiedName();
        for (EntitySet eSet : this.entityDataModel.getEntityContainer().getEntitySets()) {
            if (!eSet.getTypeName().equals(entityTypeName)) continue;
            return eSet;
        }
        return null;
    }

    private EntitySet getEntitySet(java.util.List<?> entityList) {
        return entityList.size() > 0 ? this.getEntitySet(entityList.get(0)) : null;
    }

    private EntityType getEntityType(Object entity) {
        Type type = this.entityDataModel.getType(entity.getClass());
        if (type.getMetaType() != MetaType.ENTITY) {
            throw new UnsupportedOperationException("Unsupported type: " + type);
        }
        return (EntityType)type;
    }
}

