/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json.writer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntitySet;
import com.sdl.odata.api.edm.model.Singleton;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.renderer.ODataRenderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonServiceDocumentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonServiceDocumentWriter.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final ODataUri uri;
    private final EntityDataModel entityDataModel;

    public JsonServiceDocumentWriter(ODataUri uri, EntityDataModel entityDataModel) {
        this.uri = uri;
        this.entityDataModel = entityDataModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buildJson() throws ODataRenderException {
        LOG.debug("Start building Json service root document");
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            JsonGenerator jsonGenerator = JSON_FACTORY.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("@odata.context", ODataRendererUtils.getContextURL(this.uri, this.entityDataModel));
            jsonGenerator.writeArrayFieldStart("value");
            List entities = this.entityDataModel.getEntityContainer().getEntitySets();
            for (EntitySet entity : entities) {
                if (!entity.isIncludedInServiceDocument()) continue;
                this.writeObject(jsonGenerator, entity);
            }
            List singletons = this.entityDataModel.getEntityContainer().getSingletons();
            for (Singleton singleton : singletons) {
                this.writeObject(jsonGenerator, singleton);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
            String string = stream.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw new ODataRenderException("It is unable to render service document", (Throwable)e);
        }
    }

    private void writeObject(JsonGenerator jsonGenerator, Object entity) throws IOException {
        jsonGenerator.writeStartObject();
        this.writeName(jsonGenerator, entity);
        this.writeKind(jsonGenerator, entity);
        this.writeURL(jsonGenerator, entity);
        jsonGenerator.writeEndObject();
    }

    private void writeName(JsonGenerator jsonGenerator, Object entity) throws IOException {
        jsonGenerator.writeFieldName("name");
        if (entity instanceof EntitySet) {
            jsonGenerator.writeObject((Object)((EntitySet)entity).getName());
        } else {
            jsonGenerator.writeObject((Object)((Singleton)entity).getName());
        }
    }

    private void writeKind(JsonGenerator jsonGenerator, Object entity) throws IOException {
        jsonGenerator.writeFieldName("kind");
        if (entity instanceof EntitySet) {
            jsonGenerator.writeObject((Object)"EntitySet");
        } else {
            jsonGenerator.writeObject((Object)"Singleton");
        }
    }

    private void writeURL(JsonGenerator jsonGenerator, Object entity) throws IOException {
        jsonGenerator.writeFieldName("url");
        if (entity instanceof EntitySet) {
            jsonGenerator.writeObject((Object)((EntitySet)entity).getName());
        } else {
            jsonGenerator.writeObject((Object)((Singleton)entity).getName());
        }
    }
}

