/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json.writer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.renderer.AbstractPropertyWriter;
import com.sdl.odata.renderer.json.util.JsonWriterUtil;
import com.sdl.odata.renderer.json.writer.JsonCodecMapper;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertyWriter
extends AbstractPropertyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPropertyWriter.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private JsonGenerator jsonGenerator;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public JsonPropertyWriter(ODataUri uri, EntityDataModel entityDataModel) throws ODataRenderException {
        super(uri, entityDataModel);
        try {
            this.jsonGenerator = JSON_FACTORY.createGenerator((OutputStream)this.outputStream, JsonEncoding.UTF8).setCodec((ObjectCodec)new JsonCodecMapper());
            this.jsonGenerator.writeStartObject();
        }
        catch (IOException e) {
            throw new ODataRenderException("Unable to render with following configuration");
        }
    }

    @Override
    protected String generateNullPropertyString() throws ODataRenderException {
        throw new ODataRenderException("Json Property Writer doesn't handle null property");
    }

    @Override
    protected String generatePrimitiveProperty(Object data, Type type) throws ODataRenderException {
        try {
            if (this.isCollection(data)) {
                this.jsonGenerator.writeStringField("@odata.context", ODataRendererUtils.getContextURL(this.getODataUri(), this.getEntityDataModel(), true));
                this.jsonGenerator.writeArrayFieldStart("value");
                for (Object element : (List)data) {
                    this.jsonGenerator.writeObject(element);
                }
                this.jsonGenerator.writeEndArray();
                return this.closeStream(this.outputStream);
            }
            this.jsonGenerator.writeStringField("@odata.context", ODataRendererUtils.getContextURL(this.getODataUri(), this.getEntityDataModel(), true));
            this.jsonGenerator.writeFieldName("value");
            this.jsonGenerator.writeObject(data);
            return this.closeStream(this.outputStream);
        }
        catch (IOException e) {
            throw new ODataRenderException("Unable to marshall primitive");
        }
    }

    @Override
    protected String generateComplexProperty(Object data, StructuredType type) throws ODataRenderException {
        return this.generateComplex(data, type, false);
    }

    private String generateComplex(Object data, StructuredType type, boolean isEmbedded) throws ODataRenderException {
        try {
            if (!isEmbedded) {
                this.jsonGenerator.writeStringField("@odata.context", ODataRendererUtils.getContextURL(this.getODataUri(), this.getEntityDataModel()));
            }
            this.jsonGenerator.writeFieldName("value");
            this.processData(data, type, this.jsonGenerator);
            return this.closeStream(this.outputStream);
        }
        catch (ODataException | IOException | IllegalAccessException e) {
            throw new ODataRenderException("Unable to marshall complex");
        }
    }

    private void processData(Object data, StructuredType type, JsonGenerator generator) throws IllegalAccessException, IOException, ODataException {
        if (this.isCollection(data)) {
            LOG.debug("Given property is collection of complex values");
            generator.writeStartArray();
            for (Object obj : (List)data) {
                this.writeAllProperties(obj, type, generator);
            }
            generator.writeEndArray();
        } else {
            LOG.debug("Given property is single complex value");
            this.writeAllProperties(data, type, generator);
        }
    }

    private void writeAllProperties(Object data, StructuredType type, JsonGenerator generator) throws IOException, ODataRenderException {
        generator.writeStartObject();
        EntityDataModelUtil.visitProperties((EntityDataModel)this.getEntityDataModel(), (StructuredType)type, property -> {
            try {
                if (!(property instanceof NavigationProperty)) {
                    this.handleProperty(data, property, generator);
                }
            }
            catch (ODataException | IOException | IllegalAccessException e) {
                throw new ODataRenderException("Error while writing property: " + property.getName(), e);
            }
        });
        generator.writeEndObject();
    }

    private void handleProperty(Object data, StructuralProperty property, JsonGenerator generator) throws IllegalAccessException, IOException, ODataException {
        Field field = property.getJavaField();
        field.setAccessible(true);
        Object value = field.get(data);
        LOG.trace("Property name is '{}' and its value is '{}'", (Object)property.getName(), value);
        Type type = this.getType(value);
        if (type == null) {
            String msg = String.format("Field type %s is not found in entity data model", field.getType());
            LOG.error(msg);
            throw new ODataRenderException(msg);
        }
        switch (type.getMetaType()) {
            case PRIMITIVE: {
                generator.writeFieldName(property.getName());
                this.writePrimitive(value, generator);
                break;
            }
            case COMPLEX: {
                generator.writeArrayFieldStart(property.getName());
                this.generateComplex(value, (StructuredType)type, true);
                generator.writeEndArray();
                break;
            }
            default: {
                this.defaultHandling(type);
            }
        }
    }

    private void writePrimitive(Object element, JsonGenerator generator) throws IOException, ODataRenderException {
        if (this.isCollection(element)) {
            LOG.debug("element is collection {}", element);
            generator.writeStartArray();
            for (Object obj : (List)element) {
                JsonWriterUtil.writePrimitiveValue(obj, generator);
            }
            generator.writeEndArray();
        } else if (element == null) {
            this.generateNullPropertyString();
        } else {
            JsonWriterUtil.writePrimitiveValue(element, generator);
        }
    }

    private String closeStream(ByteArrayOutputStream os) throws IOException {
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.close();
        return os.toString();
    }
}

