/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json.writer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.renderer.ODataRenderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonErrorResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonErrorResponseWriter.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    public String getJsonError(ODataException exception) throws ODataRenderException {
        ODataRendererUtils.checkNotNull(exception);
        LOG.debug("Start building Json error document");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            JsonGenerator jsonGenerator = JSON_FACTORY.createGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectFieldStart("error");
            jsonGenerator.writeStringField("code", String.valueOf(exception.getCode().getCode()));
            jsonGenerator.writeStringField("message", String.valueOf(exception.getMessage()));
            if (exception.getTarget() != null) {
                jsonGenerator.writeStringField("target", String.valueOf(exception.getTarget()).replace("\"", "'"));
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
            return outputStream.toString();
        }
        catch (IOException e) {
            LOG.error("Not possible to write error JSON.");
            throw new ODataRenderException("Not possible to write error JSON: ", (Throwable)e);
        }
    }
}

