/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sdl.odata.util.PrimitiveUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.UUID;

public final class JsonWriterUtil {
    private JsonWriterUtil() {
    }

    public static void writePrimitiveValue(Object primitiveValue, JsonGenerator jsonGenerator) throws IOException {
        Class primitiveClass = PrimitiveUtil.wrap(primitiveValue.getClass());
        if (String.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeString(String.valueOf(primitiveValue));
        } else if (Byte.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeObject(primitiveValue);
        } else if (Short.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeNumber(((Short)primitiveValue).shortValue());
        } else if (Integer.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeNumber(((Integer)primitiveValue).intValue());
        } else if (Float.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeNumber(((Float)primitiveValue).floatValue());
        } else if (Double.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeNumber(((Double)primitiveValue).doubleValue());
        } else if (Long.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeNumber(((Long)primitiveValue).longValue());
        } else if (Boolean.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeBoolean(((Boolean)primitiveValue).booleanValue());
        } else if (UUID.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeString(primitiveValue.toString());
        } else if (BigDecimal.class.isAssignableFrom(primitiveClass)) {
            jsonGenerator.writeNumber((BigDecimal)primitiveValue);
        } else {
            jsonGenerator.writeObject((Object)primitiveValue.toString());
        }
    }
}

