/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractJsonRenderer;
import com.sdl.odata.renderer.json.writer.JsonPropertyWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonValueRenderer
extends AbstractJsonRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonValueRenderer.class);
    private static final int DEFAULT_OPERATION_SCORE = 50;

    @Override
    public int score(ODataRequestContext requestContext, Object data) {
        if (!this.isNonEntityQuery(requestContext.getUri(), requestContext.getEntityDataModel())) {
            return 0;
        }
        int operationScore = 0;
        if (ODataUriUtil.isFunctionCallUri((ODataUri)requestContext.getUri()) || ODataUriUtil.isActionCallUri((ODataUri)requestContext.getUri())) {
            operationScore = 50;
        }
        int returnScore = Math.max(super.score(requestContext, data), operationScore);
        LOG.debug("Renderer score is {}", (Object)returnScore);
        return returnScore;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering property for request: {}", (Object)requestContext);
        JsonPropertyWriter propertyWriter = new JsonPropertyWriter(requestContext.getUri(), requestContext.getEntityDataModel());
        String json = propertyWriter.getPropertyAsString(data);
        LOG.debug("Response property json is {}", (Object)json);
        try {
            responseBuilder.setContentType(MediaType.JSON).setHeader("OData-Version", "4.0").setBodyText(json, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("End rendering property for request: {}", (Object)requestContext);
    }
}

