/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.json.writer.JsonServiceDocumentWriter;
import com.sdl.odata.renderer.metadata.ServiceDocumentRenderer;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonServiceDocumentRenderer
extends ServiceDocumentRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonServiceDocumentRenderer.class);

    public int score(ODataRequestContext requestContext, Object data) {
        int score = super.scoreServiceDocument(requestContext, MediaType.JSON);
        LOG.debug("Score of JSON service document renderer is {}", (Object)score);
        return score;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering entity(es) for request: {}", (Object)requestContext);
        JsonServiceDocumentWriter writer = new JsonServiceDocumentWriter(requestContext.getUri(), requestContext.getEntityDataModel());
        String json = writer.buildJson();
        try {
            responseBuilder.setContentType(MediaType.JSON).setHeader("OData-Version", "4.0").setBodyText(json, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("End rendering entity(es) for request: {}", (Object)requestContext);
    }
}

