/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractJsonRenderer;
import com.sdl.odata.renderer.json.writer.JsonWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class JsonRenderer
extends AbstractJsonRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRenderer.class);
    private String json;

    @Override
    public int score(ODataRequestContext requestContext, Object data) {
        if (!this.isEntityQuery(requestContext.getUri(), requestContext.getEntityDataModel())) {
            return 0;
        }
        int returnScore = super.score(requestContext, data);
        LOG.debug("Renderer score is {}", (Object)returnScore);
        return returnScore;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering entity(es) for request: {}", (Object)requestContext);
        JsonWriter writer = new JsonWriter(requestContext.getUri(), requestContext.getEntityDataModel());
        String contextUrl = this.buildContextURL(requestContext, data);
        this.json = data instanceof List ? writer.writeFeed((List)data, contextUrl) : writer.writeEntry(data, contextUrl);
        if (responseBuilder != null) {
            try {
                responseBuilder.setContentType(MediaType.JSON).setHeader("OData-Version", "4.0").setBodyText(this.json, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new ODataSystemException((Throwable)e);
            }
        }
        LOG.debug("End rendering entity(es) for request: {}", (Object)requestContext);
    }

    @Override
    public String getRenderedData() {
        return this.json;
    }
}

