/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.json;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractRenderer;
import com.sdl.odata.renderer.json.writer.JsonErrorResponseWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonErrorResponseRenderer
extends AbstractRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonErrorResponseRenderer.class);

    public int score(ODataRequestContext requestContext, Object data) {
        int contentTypeScore;
        if (data == null || !(data instanceof ODataException)) {
            return 0;
        }
        List accept = requestContext.getRequest().getAccept();
        int jsonAcceptScore = this.scoreByMediaType(accept, MediaType.JSON);
        int resultScore = Math.max(jsonAcceptScore, contentTypeScore = this.scoreByContentType(requestContext, MediaType.JSON));
        return resultScore > 0 ? resultScore + 100 : 0;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering error response for request: {}", (Object)requestContext);
        JsonErrorResponseWriter writer = new JsonErrorResponseWriter();
        try {
            responseBuilder.setContentType(MediaType.JSON).setHeader("Content-Language", Locale.ENGLISH.getLanguage()).setHeader("OData-Version", "4.0").setBodyText(writer.getJsonError((ODataException)data), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("End rendering error response for request: {}", (Object)requestContext);
    }
}

