/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.parser.ODataBatchException;
import com.sdl.odata.api.parser.ODataBatchRendererException;
import com.sdl.odata.api.processor.ProcessorResult;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractRenderer;
import com.sdl.odata.renderer.atom.AtomRenderer;
import com.sdl.odata.renderer.json.JsonRenderer;
import com.sdl.odata.util.ReferenceUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ODataBatchRequestRenderer
extends AbstractRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(ODataBatchRequestRenderer.class);
    private static final String HTTP_VERSION = "HTTP/1.1";
    private static final String COLON = ": ";
    private static final String CONTENT_TYPE_HTTP = "Content-Type: " + MediaType.HTTP.getSubType();
    private static final String CT_ENCODING_BINARY = "Content-Transfer-Encoding: binary";
    private static final String CONTENT_ID = "Content-ID";
    private static final String NEW_LINE = System.lineSeparator();
    private static final String FORMAT = "format";
    private static final String BODY = "body";
    private String contentLength;

    public int score(ODataRequestContext requestContext, Object data) {
        int contentTypeScore;
        if (data == null || !(data instanceof ODataException)) {
            return 0;
        }
        if (data instanceof ODataBatchException) {
            return 130;
        }
        List accept = requestContext.getRequest().getAccept();
        int batchAcceptScore = this.scoreByMediaType(accept, MediaType.MULTIPART);
        int resultScore = Math.max(batchAcceptScore, contentTypeScore = this.scoreByContentType(requestContext, MediaType.MULTIPART));
        return resultScore > 0 ? resultScore + 100 : 0;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Starting rendering batch request entities for request: {} with data {}", (Object)requestContext, data);
        ODataRendererUtils.checkNotNull(data);
        StringBuilder sb = new StringBuilder();
        this.contentLength = requestContext.getRequest().getHeader("Content-Length".toLowerCase());
        if (this.contentLength == null) {
            this.contentLength = requestContext.getRequest().getHeader("Content-Length");
        }
        String batchId = this.buildBatchId(requestContext);
        sb.append(batchId).append(NEW_LINE);
        this.buildHTTPandBinary(sb);
        sb.append(NEW_LINE);
        int changeSetCount = 0;
        if (data instanceof List) {
            List results = (List)data;
            int numberOfChangeSets = this.getNumberOfChangeSetsInResult(results);
            for (ProcessorResult result : results) {
                Map<String, String> renderMap = this.buildRenderedData(result);
                boolean isGET = result.getRequestContext().getRequest().getMethod().equals((Object)ODataRequest.Method.GET);
                if (isGET) {
                    if (!renderMap.isEmpty()) {
                        this.buildObjectData(sb, result, renderMap);
                        continue;
                    }
                    this.buildException((ODataException)new ODataBatchRendererException("Unable to render batch data"), sb, result);
                    continue;
                }
                String changeSetId = (String)result.getHeaders().get("changeSetId");
                if (++changeSetCount == 1) {
                    sb.append(batchId).append(NEW_LINE);
                    sb.append("Content-Type: ").append("multipart/mixed;boundary=").append(changeSetId).append(NEW_LINE);
                    sb.append(NEW_LINE);
                }
                sb.append("--").append(changeSetId).append(NEW_LINE);
                this.buildHTTPandBinary(sb);
                if (result.getHeaders().get(CONTENT_ID) != null) {
                    sb.append("Content-ID: ").append((String)result.getHeaders().get(CONTENT_ID)).append(NEW_LINE);
                } else {
                    sb.append("Content-ID: ").append(changeSetCount).append(NEW_LINE);
                }
                sb.append(NEW_LINE);
                if (!renderMap.isEmpty()) {
                    this.buildObjectData(sb, result, renderMap);
                } else {
                    this.buildException((ODataException)new ODataBatchRendererException("Unable to render changeset data"), sb, result);
                }
                if (changeSetCount != numberOfChangeSets) continue;
                sb.append("--").append(changeSetId).append("--").append(NEW_LINE);
            }
        } else if (data instanceof ODataException) {
            this.buildException((ODataException)data, sb, null);
        }
        sb.append(batchId).append("--").append(NEW_LINE);
        try {
            responseBuilder.setStatus(ODataResponse.Status.OK).setContentType(MediaType.MULTIPART).setHeader("OData-Version", "4.0").setBodyText(sb.toString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataSystemException((Throwable)e);
        }
        LOG.debug("Finishing rendering batch request entities for request: {}", (Object)requestContext);
    }

    private void buildHTTPandBinary(StringBuilder sb) {
        sb.append(CONTENT_TYPE_HTTP).append(NEW_LINE).append(CT_ENCODING_BINARY).append(NEW_LINE);
    }

    private void buildObjectData(StringBuilder sb, ProcessorResult result, Map<String, String> renderMap) {
        String location = (String)result.getHeaders().get("Location");
        sb.append("HTTP/1.1 ").append(result.getStatus().toString().replace("_", " ")).append(NEW_LINE);
        sb.append("Content-Type").append(COLON).append(renderMap.get(FORMAT)).append(NEW_LINE);
        if (location != null) {
            sb.append("Location").append(COLON).append(location).append(NEW_LINE);
        }
        sb.append("Content-Length").append(COLON).append(this.contentLength).append(NEW_LINE);
        sb.append(NEW_LINE);
        if (renderMap.get(BODY) != null) {
            sb.append(renderMap.get(BODY)).append(NEW_LINE).append(NEW_LINE);
        } else {
            sb.append(NEW_LINE);
        }
    }

    private void buildException(ODataException ex, StringBuilder sb, ProcessorResult result) {
        LOG.debug("{} was found. Start to create an error batch request");
        if (result != null) {
            sb.append("HTTP/1.1 ").append(result.getStatus().toString().replace("_", " ")).append(NEW_LINE);
        } else if (ex.getCode() != null) {
            if (ex.getCode().toString().equals("ENTITY_NOT_FOUND_ERROR")) {
                sb.append("HTTP/1.1 ").append(ODataResponse.Status.NOT_FOUND.toString().replace("_", " ")).append(NEW_LINE);
            } else {
                sb.append("HTTP/1.1 ").append(ODataResponse.Status.BAD_REQUEST.toString().replace("_", " ")).append(NEW_LINE);
            }
        }
        sb.append(CONTENT_TYPE_HTTP).append(NEW_LINE);
        sb.append("Content-Length").append(COLON).append(this.contentLength).append(NEW_LINE).append(NEW_LINE);
        sb.append(ex.getMessage()).append(NEW_LINE);
    }

    private Map<String, String> buildRenderedData(ProcessorResult result) throws ODataException {
        LOG.debug("Start to render the data");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (result.getStatus().getCode() < ODataResponse.Status.NO_CONTENT.getCode()) {
            String contentType = (String)result.getHeaders().get("Content-Type");
            if (!result.getHeaders().containsKey("Content-Type") || contentType.startsWith(MediaType.ATOM_XML.toString())) {
                resultMap.put(FORMAT, MediaType.ATOM_XML.toString());
                resultMap.put(BODY, this.getRenderedXML(result));
            } else if (contentType.startsWith(MediaType.JSON.toString())) {
                resultMap.put(FORMAT, MediaType.JSON.toString());
                resultMap.put(BODY, this.getRenderedJSON(result));
            }
        } else {
            resultMap.put(FORMAT, MediaType.HTTP.getSubType());
            resultMap.put(BODY, (String)result.getData());
        }
        return resultMap;
    }

    private String getRenderedJSON(ProcessorResult result) throws ODataException {
        LOG.debug("JSON found as the content type. JSON Renderer will be used to render the result data");
        JsonRenderer renderer = new JsonRenderer();
        renderer.render(result.getRequestContext(), result.getData(), null);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Object jsonObject = objectMapper.readValue(renderer.getRenderedData(), Object.class);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
        }
        catch (IOException ex) {
            throw new ODataBatchRendererException("Unable to pretty print following json data");
        }
    }

    private String getRenderedXML(ProcessorResult result) throws ODataException {
        LOG.debug("Content Type not specified. Atom Renderer will be used to render the result data");
        AtomRenderer atomRenderer = new AtomRenderer();
        atomRenderer.render(result.getRequestContext(), result.getData(), null);
        return ((AbstractRenderer)atomRenderer).getRenderedData();
    }

    private int getNumberOfChangeSetsInResult(List<ProcessorResult> result) {
        int changeSets = 0;
        for (ProcessorResult processorResult : result) {
            if (processorResult.getRequestContext().getRequest().getMethod().equals((Object)ODataRequest.Method.GET)) continue;
            ++changeSets;
        }
        return changeSets;
    }

    private String buildBatchId(ODataRequestContext requestContext) throws ODataBatchRendererException {
        StringBuilder sb = new StringBuilder();
        String contentType = (String)requestContext.getRequest().getHeaders().get("Content-Type".toLowerCase());
        if (contentType == null) {
            contentType = requestContext.getRequest().getHeader("Content-Type");
        }
        if (ReferenceUtil.isNullOrEmpty((String)contentType)) {
            throw new ODataBatchRendererException("Request Context Content-Type is missing");
        }
        sb.append("--");
        sb.append(contentType.substring(contentType.indexOf("=") + 1));
        return sb.toString();
    }
}

