/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.atom.writer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.renderer.atom.writer.AtomDataWriter;
import com.sdl.odata.renderer.atom.writer.AtomMetadataWriter;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.List;

public class AtomWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AtomWriter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private XMLStreamWriter xmlWriter = null;
    private ByteArrayOutputStream outputStream = null;
    private AtomMetadataWriter metadataWriter = null;
    private AtomDataWriter dataWriter = null;
    private final ZonedDateTime dateTime;
    private final ODataUri oDataUri;
    private final EntityDataModel entityDataModel;
    private final java.util.List<String> expandedProperties = new ArrayList<String>();
    private String contextURL;
    private final boolean isWriteOperation;
    private final boolean isDeepInsert;
    private final boolean isActionCall;

    public AtomWriter(ZonedDateTime dateTime, ODataUri oDataUri, EntityDataModel entityDataModel, boolean isWriteOperation, boolean isActionCall) {
        this.dateTime = ODataRendererUtils.checkNotNull(dateTime);
        this.oDataUri = ODataRendererUtils.checkNotNull(oDataUri);
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
        this.isWriteOperation = ODataRendererUtils.checkNotNull(isWriteOperation);
        this.isDeepInsert = false;
        this.isActionCall = isActionCall;
        this.expandedProperties.addAll(ODataUriUtil.asJavaList((List)ODataUriUtil.getSimpleExpandPropertyNames((ODataUri)oDataUri)));
    }

    public void startDocument() throws ODataRenderException {
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.xmlWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(this.outputStream, StandardCharsets.UTF_8.name());
            this.metadataWriter = new AtomMetadataWriter(this.xmlWriter, this.oDataUri, this.entityDataModel);
            this.dataWriter = new AtomDataWriter(this.xmlWriter, this.entityDataModel);
            this.xmlWriter.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            this.xmlWriter.setPrefix("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
            this.xmlWriter.setPrefix("data", "http://docs.oasis-open.org/odata/ns/data");
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to start stream XML");
            throw new ODataRenderException("Not possible to start stream XML: ", (Throwable)e);
        }
    }

    public void endDocument() throws ODataRenderException {
        try {
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            LOG.error("Not possible to end stream XML");
            throw new ODataRenderException("Not possible to end stream XML: ", (Throwable)e);
        }
    }

    public void writeFeed(java.util.List<?> entities, String requestContextURL) throws ODataRenderException {
        ODataRendererUtils.checkNotNull(entities);
        this.contextURL = ODataRendererUtils.checkNotNull(requestContextURL);
        try {
            this.writeFeed(entities, null, null);
        }
        catch (ODataEdmException | IllegalAccessException | NoSuchFieldException | XMLStreamException e) {
            LOG.error("Not possible to marshall feed stream XML");
            throw new ODataRenderException("Not possible to marshall feed stream XML: ", e);
        }
    }

    public void writeEntry(Object entity, String requestContextURL) throws ODataRenderException {
        ODataRendererUtils.checkNotNull(entity);
        this.contextURL = ODataRendererUtils.checkNotNull(requestContextURL);
        try {
            this.writeEntry(entity, false);
        }
        catch (ODataEdmException | IllegalAccessException | NoSuchFieldException | XMLStreamException e) {
            LOG.error("Not possible to render single entity stream XML");
            throw new ODataRenderException("Not possible to render single entity stream XML: ", e);
        }
    }

    public String getXml() {
        return this.outputStream.toString();
    }

    private void writeFeed(Collection<?> entities, Object enclosingEntity, NavigationProperty property) throws XMLStreamException, ODataRenderException, NoSuchFieldException, IllegalAccessException, ODataEdmException {
        boolean isInlineFeed = enclosingEntity != null;
        this.startFeed(isInlineFeed);
        this.metadataWriter.writeFeedId(enclosingEntity, property);
        this.metadataWriter.writeTitle();
        this.metadataWriter.writeUpdate(this.dateTime);
        this.metadataWriter.writeFeedLink(enclosingEntity, property);
        for (Object entity : entities) {
            this.writeEntry(entity, true);
        }
        this.endFeed();
    }

    private void writeEntry(Object entity, boolean isFeedEntry) throws XMLStreamException, ODataRenderException, NoSuchFieldException, IllegalAccessException, ODataEdmException {
        EntityType entityType = EntityDataModelUtil.getAndCheckEntityType((EntityDataModel)this.entityDataModel, entity.getClass());
        this.startEntry(isFeedEntry);
        this.metadataWriter.writeEntryId(entity);
        this.metadataWriter.writeTitle();
        this.metadataWriter.writeSummary();
        this.metadataWriter.writeUpdate(this.dateTime);
        this.metadataWriter.writeAuthor();
        this.metadataWriter.writeEntryEntityLink(entity);
        for (StructuralProperty property : entityType.getStructuralProperties()) {
            if (!(property instanceof NavigationProperty)) continue;
            if (this.isWriteOperation && property.isNullable()) {
                Object value = EntityDataModelUtil.getPropertyValue((StructuralProperty)property, (Object)entity);
                if (property.isCollection()) {
                    if (value == null || ((Collection)value).size() <= 0) continue;
                    LOG.trace("TODO Handle Collections check");
                    continue;
                }
                if (value == null) continue;
                NavigationProperty navigationProperty = (NavigationProperty)property;
                this.writeEntryPropertyLink(entity, navigationProperty);
                continue;
            }
            NavigationProperty navigationProperty = (NavigationProperty)property;
            this.writeEntryPropertyLink(entity, navigationProperty);
        }
        this.metadataWriter.writeEntryCategory(entity);
        this.dataWriter.writeData(entity, entityType);
        this.endEntry();
    }

    private void startFeed(boolean isInline) throws XMLStreamException {
        this.xmlWriter.writeStartElement("feed");
        if (!isInline) {
            this.metadataWriter.writeODataMetadata(this.contextURL);
        }
    }

    private void endFeed() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
    }

    private void startEntry(boolean isFeedEntry) throws XMLStreamException {
        this.xmlWriter.writeStartElement("entry");
        if (!isFeedEntry) {
            this.metadataWriter.writeODataMetadata(this.contextURL);
        }
    }

    private void endEntry() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
    }

    private void writeEntryPropertyLink(Object entity, NavigationProperty property) throws XMLStreamException, ODataRenderException, NoSuchFieldException, IllegalAccessException, ODataEdmException {
        String linkType = property.isCollection() ? "%s;type=feed" : "%s;type=entry";
        this.startLink();
        this.xmlWriter.writeAttribute("rel", "http://docs.oasis-open.org/odata/ns/related/" + property.getName());
        this.xmlWriter.writeAttribute("type", String.format(linkType, MediaType.ATOM_XML.toString()));
        this.xmlWriter.writeAttribute("title", property.getName());
        if (this.isDeepInsert) {
            this.xmlWriter.writeAttribute("href", this.getHrefAttributeValue(entity, property));
            Object value = EntityDataModelUtil.getPropertyValue((StructuralProperty)property, (Object)entity);
            if (property.isCollection()) {
                if (value != null && ((Collection)value).size() > 0) {
                    this.startMetadata();
                    this.writeFeed((Collection)value, entity, property);
                    this.endMetadata();
                }
            } else if (value != null) {
                this.startMetadata();
                this.writeEntry(value, true);
                this.endMetadata();
            }
        } else if (this.isWriteOperation && !this.isActionCall) {
            Object value = EntityDataModelUtil.getPropertyValue((StructuralProperty)property, (Object)entity);
            if (property.isCollection()) {
                this.xmlWriter.writeAttribute("href", String.format("%s(%s)/%s", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, (Object)entity), property.getName()));
            } else if (value != null) {
                if (EntityDataModelUtil.isSingletonEntity((EntityDataModel)this.entityDataModel, (Object)EntityDataModelUtil.getPropertyValue((StructuralProperty)property, (Object)entity))) {
                    this.xmlWriter.writeAttribute("href", String.format("%s", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)value)));
                } else {
                    this.xmlWriter.writeAttribute("href", String.format("%s(%s)", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)value), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, (Object)value)));
                }
            }
        } else if (this.isActionCall || this.expandedProperties.contains(property.getName())) {
            this.xmlWriter.writeAttribute("href", this.getHrefAttributeValue(entity, property));
            Object value = EntityDataModelUtil.getPropertyValue((StructuralProperty)property, (Object)entity);
            this.startMetadata();
            if (value != null) {
                if (property.isCollection()) {
                    this.writeFeed((Collection)value, entity, property);
                } else {
                    this.writeEntry(value, true);
                }
            }
            this.endMetadata();
        } else {
            this.xmlWriter.writeAttribute("href", this.getHrefAttributeValue(entity, property));
        }
        this.endLink();
        this.startLink();
        this.xmlWriter.writeAttribute("rel", "http://docs.oasis-open.org/odata/ns/relatedlinks/" + property.getName());
        this.xmlWriter.writeAttribute("type", MediaType.XML.toString());
        this.xmlWriter.writeAttribute("title", property.getName());
        if (EntityDataModelUtil.isSingletonEntity((EntityDataModel)this.entityDataModel, (Object)entity)) {
            this.xmlWriter.writeAttribute("href", String.format("%s/%s/$ref", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity), property.getName()));
        } else {
            this.xmlWriter.writeAttribute("href", String.format("%s(%s)/%s/$ref", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, (Object)entity), property.getName()));
        }
        this.endLink();
    }

    private void startMetadata() throws XMLStreamException {
        this.xmlWriter.writeStartElement("metadata", "inline", "");
    }

    private void endMetadata() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
    }

    private void startLink() throws XMLStreamException {
        this.xmlWriter.writeStartElement("link");
    }

    private void endLink() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
    }

    private String getHrefAttributeValue(Object entity, NavigationProperty property) throws ODataEdmException {
        if (EntityDataModelUtil.isSingletonEntity((EntityDataModel)this.entityDataModel, (Object)entity)) {
            return String.format("%s/%s", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity), property.getName());
        }
        return String.format("%s(%s)/%s", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, (Object)entity), property.getName());
    }
}

