/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.atom.writer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import scala.Option;

public class AtomMetadataWriter {
    private final XMLStreamWriter xmlWriter;
    private final ODataUri oDataUri;
    private final EntityDataModel entityDataModel;

    public AtomMetadataWriter(XMLStreamWriter xmlWriter, ODataUri oDataUri, EntityDataModel entityDataModel) {
        this.xmlWriter = ODataRendererUtils.checkNotNull(xmlWriter);
        this.oDataUri = ODataRendererUtils.checkNotNull(oDataUri);
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
    }

    void writeODataMetadata(String contextURL) throws XMLStreamException {
        this.xmlWriter.writeNamespace("metadata", "http://docs.oasis-open.org/odata/ns/metadata");
        this.xmlWriter.writeNamespace("data", "http://docs.oasis-open.org/odata/ns/data");
        this.xmlWriter.writeDefaultNamespace("http://www.w3.org/2005/Atom");
        this.xmlWriter.writeAttribute("http://docs.oasis-open.org/odata/ns/metadata", "context", contextURL);
        this.xmlWriter.writeAttribute("xml:base", this.oDataUri.serviceRoot());
    }

    void writeTitle() throws XMLStreamException {
        this.xmlWriter.writeStartElement("title");
        this.xmlWriter.writeEndElement();
    }

    void writeSummary() throws XMLStreamException {
        this.xmlWriter.writeStartElement("summary");
        this.xmlWriter.writeEndElement();
    }

    void writeUpdate(ZonedDateTime dateTime) throws XMLStreamException {
        this.xmlWriter.writeStartElement("updated");
        this.xmlWriter.writeCharacters(dateTime.format(DateTimeFormatter.ISO_INSTANT));
        this.xmlWriter.writeEndElement();
    }

    void writeAuthor() throws XMLStreamException {
        this.xmlWriter.writeStartElement("author");
        this.xmlWriter.writeStartElement("name");
        this.xmlWriter.writeCharacters("SDL OData v4 framework");
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndElement();
    }

    void writeEntryId(Object entity) throws XMLStreamException, ODataEdmException {
        this.xmlWriter.writeStartElement("id");
        this.xmlWriter.writeCharacters(this.getEntryIdString(entity));
        this.xmlWriter.writeEndElement();
    }

    void writeFeedId() throws XMLStreamException, ODataEdmException {
        this.writeFeedId(null, null);
    }

    void writeFeedId(Object entity, NavigationProperty property) throws XMLStreamException, ODataEdmException {
        this.xmlWriter.writeStartElement("id");
        if (entity != null) {
            this.xmlWriter.writeCharacters(String.format("%s/%s/%s", this.oDataUri.serviceRoot(), this.getEntityWithKey(entity), property.getName()));
        } else {
            String id = ODataUriUtil.isActionCallUri((ODataUri)this.oDataUri) || ODataUriUtil.isFunctionCallUri((ODataUri)this.oDataUri) ? this.buildFeedIdFromOperationCall(this.oDataUri) : (String)ODataUriUtil.getEntitySetId((ODataUri)this.oDataUri).get();
            this.xmlWriter.writeCharacters(id);
        }
        this.xmlWriter.writeEndElement();
    }

    private String buildFeedIdFromOperationCall(ODataUri odataUri) {
        String serviceRoot = odataUri.serviceRoot();
        String returnType = ODataUriUtil.getOperationReturnType((ODataUri)odataUri, (EntityDataModel)this.entityDataModel);
        return serviceRoot + "/" + returnType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeFeedLink(Object entity, NavigationProperty property) throws XMLStreamException, ODataEdmException {
        this.xmlWriter.writeStartElement("link");
        this.xmlWriter.writeAttribute("rel", "self");
        if (entity == null) {
            if (ODataUriUtil.isActionCallUri((ODataUri)this.oDataUri) || ODataUriUtil.isFunctionCallUri((ODataUri)this.oDataUri)) {
                Option targetTypeOption = ODataUriUtil.resolveTargetType((ODataUri)this.oDataUri, (EntityDataModel)this.entityDataModel);
                if (!targetTypeOption.isDefined()) throw new ODataEdmException("Failed to resolve entity target type");
                TargetType targetType = (TargetType)targetTypeOption.get();
                String entitySetName = EntityDataModelUtil.getEntitySetByEntityTypeName((EntityDataModel)this.entityDataModel, (String)targetType.typeName()).getName();
                this.xmlWriter.writeAttribute("title", entitySetName);
                this.xmlWriter.writeAttribute("href", entitySetName);
            } else {
                this.xmlWriter.writeAttribute("title", (String)ODataUriUtil.getEntitySetName((ODataUri)this.oDataUri).get());
                this.xmlWriter.writeAttribute("href", (String)ODataUriUtil.getEntitySetName((ODataUri)this.oDataUri).get());
            }
        } else {
            this.xmlWriter.writeAttribute("title", property.getName());
            this.xmlWriter.writeAttribute("href", String.format("%s/%s", this.getEntityWithKey(entity), property.getName()));
        }
        this.xmlWriter.writeEndElement();
    }

    public void writeEntryEntityLink(Object entity) throws XMLStreamException, ODataEdmException {
        EntityType entityType = EntityDataModelUtil.getAndCheckEntityType((EntityDataModel)this.entityDataModel, entity.getClass());
        this.xmlWriter.writeStartElement("link");
        if (entityType.isReadOnly()) {
            this.xmlWriter.writeAttribute("rel", "self");
        } else {
            this.xmlWriter.writeAttribute("rel", "edit");
        }
        this.xmlWriter.writeAttribute("title", entityType.getName());
        this.xmlWriter.writeAttribute("href", this.getEntityWithKey(entity));
        this.xmlWriter.writeEndElement();
    }

    void writeEntryCategory(Object entity) throws XMLStreamException {
        Type entityType = this.entityDataModel.getType(entity.getClass());
        this.xmlWriter.writeStartElement("category");
        this.xmlWriter.writeAttribute("scheme", "http://docs.oasis-open.org/odata/ns/scheme");
        this.xmlWriter.writeAttribute("term", String.format("%s%s.%s", "#", entityType.getNamespace(), entityType.getName()));
        this.xmlWriter.writeEndElement();
    }

    private String getEntityWithKey(Object entity) throws ODataEdmException {
        if (EntityDataModelUtil.isSingletonEntity((EntityDataModel)this.entityDataModel, (Object)entity)) {
            return String.format("%s", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity));
        }
        return String.format("%s(%s)", EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, (Object)entity));
    }

    private String getEntryIdString(Object entity) throws ODataEdmException {
        if (EntityDataModelUtil.isSingletonEntity((EntityDataModel)this.entityDataModel, (Object)entity)) {
            return String.format("%s/%s", this.oDataUri.serviceRoot(), EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity));
        }
        return String.format("%s/%s(%s)", this.oDataUri.serviceRoot(), EntityDataModelUtil.getEntityName((EntityDataModel)this.entityDataModel, (Object)entity), EntityDataModelUtil.formatEntityKey((EntityDataModel)this.entityDataModel, (Object)entity));
    }
}

