/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.atom.writer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.EntityType;
import com.sdl.odata.api.edm.model.EnumType;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.NavigationProperty;
import com.sdl.odata.api.edm.model.PrimitiveType;
import com.sdl.odata.api.edm.model.StructuralProperty;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.edm.model.TypeDefinition;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomDataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AtomDataWriter.class);
    private final XMLStreamWriter xmlWriter;
    private final EntityDataModel entityDataModel;

    public AtomDataWriter(XMLStreamWriter xmlWriter, EntityDataModel entityDataModel) {
        this.xmlWriter = ODataRendererUtils.checkNotNull(xmlWriter);
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
    }

    public void writeData(Object entity, EntityType entityType) throws XMLStreamException, ODataRenderException {
        this.xmlWriter.writeStartElement("content");
        this.xmlWriter.writeAttribute("type", MediaType.XML.toString());
        this.xmlWriter.writeStartElement("metadata", "properties", "");
        this.marshall(entity, (Type)entityType);
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndElement();
    }

    private void marshall(Object object, Type type) throws XMLStreamException, ODataRenderException {
        switch (type.getMetaType()) {
            case ABSTRACT: {
                throw new UnsupportedOperationException("Marshalling abstract OData types is not supported");
            }
            case PRIMITIVE: {
                this.marshallPrimitive(object, (PrimitiveType)type);
                break;
            }
            case ENTITY: 
            case COMPLEX: {
                this.marshallStructured(object, (StructuredType)type);
                break;
            }
            case ENUM: {
                this.marshallEnum(object, (EnumType)type);
                break;
            }
            case TYPE_DEFINITION: {
                this.marshallPrimitive(object, ((TypeDefinition)type).getUnderlyingType());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + type);
            }
        }
    }

    private void marshallPrimitive(Object value, PrimitiveType primitiveType) throws XMLStreamException {
        LOG.debug("Primitive value: {} of type: {}", value, (Object)primitiveType);
        if (value != null) {
            this.xmlWriter.writeCharacters(value.toString());
        }
    }

    private void marshallStructured(Object object, StructuredType structuredType) throws ODataRenderException, XMLStreamException {
        LOG.debug("Start structured value of type: {}", (Object)structuredType);
        if (object != null) {
            EntityDataModelUtil.visitProperties((EntityDataModel)this.entityDataModel, (StructuredType)structuredType, property -> {
                try {
                    if (!(property instanceof NavigationProperty)) {
                        this.marshallStructuralProperty(object, property);
                    }
                }
                catch (XMLStreamException e) {
                    throw new ODataRenderException("Error while writing property: " + property.getName(), (Throwable)e);
                }
            });
        } else {
            LOG.debug("Structured value is null");
        }
        LOG.debug("End structured value of type: {}", (Object)structuredType);
    }

    private void marshallStructuralProperty(Object object, StructuralProperty property) throws ODataRenderException, XMLStreamException {
        Object propertyValue;
        String propertyName = property.getName();
        Field field = property.getJavaField();
        try {
            field.setAccessible(true);
            propertyValue = field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new ODataRenderException("Error getting field value of field: " + field.toGenericString());
        }
        if (propertyValue == null) {
            if (property.isCollection()) {
                throw new ODataRenderException("Collection property has null value: " + property);
            }
            if (!property.isNullable()) {
                throw new ODataRenderException("Non-nullable property has null value: " + property);
            }
        }
        if (property.isCollection()) {
            Iterator<Object> iterator;
            if (propertyValue.getClass().isArray()) {
                iterator = Arrays.asList((Object[])propertyValue).iterator();
            } else if (Collection.class.isAssignableFrom(propertyValue.getClass())) {
                iterator = ((Collection)propertyValue).iterator();
            } else {
                throw new UnsupportedOperationException("Unsupported collection type: " + propertyValue.getClass().getName() + " for property: " + propertyName);
            }
            Type elementType = this.entityDataModel.getType(property.getElementTypeName());
            if (elementType == null) {
                throw new ODataRenderException("OData type not found for elements of property: " + property);
            }
            LOG.debug("Start collection property: {}", (Object)propertyName);
            this.xmlWriter.writeStartElement("data", propertyName, "http://docs.oasis-open.org/odata/ns/data");
            if (elementType.getMetaType().equals((Object)MetaType.PRIMITIVE)) {
                this.xmlWriter.writeAttribute("metadata", "http://docs.oasis-open.org/odata/ns/metadata", "type", "#Collection(" + elementType.getName() + ")");
            } else {
                this.xmlWriter.writeAttribute("metadata", "http://docs.oasis-open.org/odata/ns/metadata", "type", "#Collection(" + elementType.getFullyQualifiedName() + ")");
            }
            while (iterator.hasNext()) {
                Object element = iterator.next();
                this.xmlWriter.writeStartElement("metadata", "element", "http://docs.oasis-open.org/odata/ns/metadata");
                this.marshall(element, elementType);
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
            LOG.debug("End collection property: {}", (Object)propertyName);
        } else {
            LOG.debug("Start property: {}", (Object)propertyName);
            Type propertyType = this.entityDataModel.getType(property.getTypeName());
            if (propertyType == null) {
                throw new ODataRenderException("OData type not found for property: " + property);
            }
            this.xmlWriter.writeStartElement("data", propertyName, "http://docs.oasis-open.org/odata/ns/data");
            if (propertyValue == null) {
                this.xmlWriter.writeAttribute("metadata", "http://docs.oasis-open.org/odata/ns/metadata", "null", "true");
            }
            switch (propertyType.getMetaType()) {
                case PRIMITIVE: {
                    PrimitiveType primitiveType = (PrimitiveType)propertyType;
                    if (primitiveType.equals((Object)PrimitiveType.STRING)) break;
                    this.xmlWriter.writeAttribute("metadata", "http://docs.oasis-open.org/odata/ns/metadata", "type", primitiveType.getName());
                    break;
                }
                case ENTITY: 
                case COMPLEX: 
                case ENUM: {
                    this.xmlWriter.writeAttribute("metadata", "http://docs.oasis-open.org/odata/ns/metadata", "type", "#" + propertyType.getFullyQualifiedName());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported meta type: " + propertyType.getMetaType());
                }
            }
            this.marshall(propertyValue, propertyType);
            this.xmlWriter.writeEndElement();
            LOG.debug("End property: {}", (Object)propertyName);
        }
    }

    private void marshallEnum(Object value, EnumType enumType) throws XMLStreamException {
        LOG.debug("Enum value: {} of type: {}", value, (Object)enumType);
        this.xmlWriter.writeCharacters(value.toString());
    }
}

