/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer.atom;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataRequestContextUtil;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.renderer.AbstractAtomRenderer;
import com.sdl.odata.renderer.atom.writer.AtomWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class AtomRenderer
extends AbstractAtomRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(AtomRenderer.class);
    private String renderedData;

    @Override
    public int score(ODataRequestContext requestContext, Object data) {
        if (!this.isEntityQuery(requestContext.getUri(), requestContext.getEntityDataModel())) {
            return 0;
        }
        int returnScore = super.score(requestContext, data);
        LOG.debug("Renderer score is {}", (Object)returnScore);
        return returnScore;
    }

    public void render(ODataRequestContext requestContext, Object data, ODataResponse.Builder responseBuilder) throws ODataException {
        LOG.debug("Start rendering entity(es) for request: {} with data {}", (Object)requestContext, data);
        ZonedDateTime dateTime = ZonedDateTime.now();
        AtomWriter atomWriter = new AtomWriter(dateTime, requestContext.getUri(), requestContext.getEntityDataModel(), ODataRequestContextUtil.isWriteOperation((ODataRequestContext)requestContext), ODataUriUtil.isActionCallUri((ODataUri)requestContext.getUri()));
        atomWriter.startDocument();
        if (data instanceof List) {
            atomWriter.writeFeed((List)data, this.buildContextURL(requestContext, data));
        } else {
            atomWriter.writeEntry(data, this.buildContextURL(requestContext, data));
        }
        atomWriter.endDocument();
        this.renderedData = atomWriter.getXml();
        if (responseBuilder != null) {
            try {
                responseBuilder.setContentType(MediaType.ATOM_XML).setHeader("OData-Version", "4.0").setBodyText(this.renderedData, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new ODataSystemException((Throwable)e);
            }
        }
        LOG.debug("End rendering entity(es) for request: {}", (Object)requestContext);
    }

    @Override
    public String getRenderedData() {
        return this.renderedData;
    }
}

