/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.FormatOption;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.api.renderer.ODataRenderer;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataRequestContextUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class AbstractRenderer
implements ODataRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRenderer.class);
    public static final int WILDCARD_MATCH_SCORE = 30;
    public static final int DEFAULT_SCORE = 0;
    public static final int CONTENT_TYPE_HEADER = 35;
    public static final int MAXIMUM_FORMAT_SCORE = 130;
    public static final int MAXIMUM_HEADER_SCORE = 100;
    public static final int DELETE_LINK_SCORE = 100;
    public static final int ERROR_EXTRA_SCORE = 100;
    public static final int PRIORITY_SCORE = 1;
    protected static final String ODATA_VERSION_HEADER = "4.0";

    protected boolean isEntityQuery(ODataUri uri, EntityDataModel entityDataModel) {
        Type type = this.getTargetTypeOrNull(uri, entityDataModel);
        return type != null && type.getMetaType() == MetaType.ENTITY;
    }

    protected boolean isGetRequest(ODataRequest request) {
        return request.getMethod() == ODataRequest.Method.GET;
    }

    protected boolean isNonEntityQuery(ODataUri uri, EntityDataModel entityDataModel) {
        Type type = this.getTargetTypeOrNull(uri, entityDataModel);
        return type != null && type.getMetaType() != MetaType.ENTITY;
    }

    private Type getTargetTypeOrNull(ODataUri uri, EntityDataModel entityDataModel) {
        Option targetTypeOption = ODataUriUtil.resolveTargetType((ODataUri)uri, (EntityDataModel)entityDataModel);
        if (!targetTypeOption.isEmpty()) {
            TargetType targetType = (TargetType)targetTypeOption.get();
            LOG.debug("Target type is {} and is it collection {}", (Object)targetType.typeName(), (Object)targetType.isCollection());
            return entityDataModel.getType(targetType.typeName());
        }
        return null;
    }

    protected int scoreByFormat(Option<FormatOption> formatOption, MediaType requiredMediaType) {
        if (!formatOption.isDefined()) {
            return 0;
        }
        if (((FormatOption)formatOption.get()).mediaType().matches(requiredMediaType)) {
            return 130;
        }
        return 0;
    }

    protected int scoreByMediaType(List<MediaType> mediaTypes, MediaType requiredMediaType) {
        int score = 100;
        boolean match = false;
        boolean matchWildCard = false;
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.matches(requiredMediaType)) {
                if (mediaType.isWildCardMediaType()) {
                    matchWildCard = true;
                }
                match = true;
                break;
            }
            score -= 2;
        }
        return match && !matchWildCard ? score : (matchWildCard ? 30 : 0);
    }

    protected int scoreByContentType(ODataRequestContext oDataRequestContext, MediaType expected) {
        if (this.checkForContentType(oDataRequestContext, expected)) {
            return 35;
        }
        return 0;
    }

    private boolean checkForContentType(ODataRequestContext oDataRequestContext, MediaType expected) {
        MediaType requestContentType = oDataRequestContext.getRequest().getContentType();
        return requestContentType != null && requestContentType.matches(expected);
    }

    protected boolean isRequestedContentTypeSupported(ODataRequestContext oDataRequestContext) {
        return this.checkForContentType(oDataRequestContext, MediaType.ATOM_XML) || this.checkForContentType(oDataRequestContext, MediaType.JSON);
    }

    protected boolean isCollection(Object data) {
        return data instanceof List;
    }

    protected String buildContextURL(ODataRequestContext requestContext, Object data) throws ODataRenderException {
        ODataUri oDataUri = requestContext.getUri();
        if (ODataUriUtil.isActionCallUri((ODataUri)oDataUri) || ODataUriUtil.isFunctionCallUri((ODataUri)oDataUri)) {
            return ODataRendererUtils.buildContextUrlFromOperationCall(oDataUri, requestContext.getEntityDataModel(), this.isCollection(data));
        }
        Option contextURL = ODataRequestContextUtil.isWriteOperation((ODataRequestContext)requestContext) ? ODataUriUtil.getContextUrlWriteOperation((ODataUri)oDataUri) : ODataUriUtil.getContextUrl((ODataUri)oDataUri);
        this.checkContextURL(requestContext, (Option<String>)contextURL);
        return (String)contextURL.get();
    }

    protected void checkContextURL(ODataRequestContext requestContext, Option<String> contextURL) throws ODataRenderException {
        if (!contextURL.isDefined()) {
            throw new ODataRenderException(String.format("Not possible to create context URL for request %s", requestContext));
        }
    }

    public String getRenderedData() {
        return null;
    }
}

