/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer;

import com.sdl.odata.ODataRendererUtils;
import com.sdl.odata.api.ODataClientException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.ODataEdmException;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.StructuredType;
import com.sdl.odata.api.edm.model.Type;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.renderer.ODataRenderException;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class AbstractPropertyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertyWriter.class);
    private final ODataUri oDataUri;
    private final EntityDataModel entityDataModel;
    private final TargetType targetType;

    public AbstractPropertyWriter(ODataUri oDataUri, EntityDataModel entityDataModel) throws ODataRenderException {
        this.oDataUri = ODataRendererUtils.checkNotNull(oDataUri);
        this.entityDataModel = ODataRendererUtils.checkNotNull(entityDataModel);
        this.targetType = this.getTargetType();
    }

    public String getPropertyAsString(Object data) throws ODataException {
        LOG.debug("GetPropertyAsString invoked with {}", data);
        if (data != null) {
            return this.makePropertyString(data);
        }
        return this.generateNullPropertyString();
    }

    protected abstract String generateNullPropertyString() throws ODataException;

    protected abstract String generatePrimitiveProperty(Object var1, Type var2) throws ODataException;

    protected abstract String generateComplexProperty(Object var1, StructuredType var2) throws ODataException;

    private String makePropertyString(Object data) throws ODataException {
        String propertyXML = null;
        Type type = this.getTypeFromODataUri();
        this.validateRequest(type, data);
        switch (type.getMetaType()) {
            case PRIMITIVE: {
                LOG.debug("Given property type is primitive");
                propertyXML = this.generatePrimitiveProperty(data, type);
                break;
            }
            case COMPLEX: {
                LOG.debug("Given property type is complex");
                propertyXML = this.generateComplexProperty(data, (StructuredType)type);
                break;
            }
            default: {
                this.defaultHandling(type);
            }
        }
        return propertyXML;
    }

    private void validateRequest(Type type, Object data) throws ODataRenderException, ODataClientException, ODataEdmException {
        if (!this.areValidTypesToProceed(type, data)) {
            throw new ODataRenderException("ODataUri type is not matched with given 'data' type");
        }
    }

    private boolean areValidTypesToProceed(Type type, Object data) throws ODataRenderException, ODataEdmException {
        return this.isEmptyCollection(data) || !(this.isCollection(data) ^ this.targetType.isCollection()) && this.getType(data).equals(type);
    }

    protected Type getTypeFromODataUri() throws ODataRenderException {
        return this.entityDataModel.getType(this.targetType.typeName());
    }

    private TargetType getTargetType() throws ODataRenderException {
        Option targetTypeOption = ODataUriUtil.resolveTargetType((ODataUri)this.oDataUri, (EntityDataModel)this.entityDataModel);
        if (targetTypeOption.isEmpty()) {
            throw new ODataRenderException("Target type should not be empty");
        }
        return (TargetType)targetTypeOption.get();
    }

    protected Type getType(Object data) throws ODataEdmException {
        Type type;
        if (this.isCollection(data)) {
            LOG.debug("Given property is collection");
            type = EntityDataModelUtil.getAndCheckType((EntityDataModel)this.entityDataModel, ((List)data).get(0).getClass());
        } else {
            type = EntityDataModelUtil.getAndCheckType((EntityDataModel)this.entityDataModel, data.getClass());
        }
        return type;
    }

    protected boolean isEmptyCollection(Object data) {
        return this.isCollection(data) && ((List)data).isEmpty();
    }

    protected boolean isCollection(Object data) {
        return data instanceof List;
    }

    protected ODataUri getODataUri() {
        return this.oDataUri;
    }

    protected EntityDataModel getEntityDataModel() {
        return this.entityDataModel;
    }

    protected void defaultHandling(Type type) throws ODataRenderException {
        String msg = String.format("Unhandled object type %s", type);
        LOG.warn(msg);
        throw new ODataRenderException(msg);
    }
}

