/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer;

import com.sdl.odata.api.parser.FormatOption;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.renderer.AbstractRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class AbstractJsonRenderer
extends AbstractRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJsonRenderer.class);

    public int score(ODataRequestContext requestContext, Object data) {
        int formatScore = this.scoreByFormat((Option<FormatOption>)ODataUriUtil.getFormatOption((ODataUri)requestContext.getUri()), MediaType.JSON);
        List accept = requestContext.getRequest().getAccept();
        int acceptScore = this.scoreByMediaType(accept, MediaType.JSON);
        int totalScore = Math.max(formatScore, acceptScore);
        if (this.isRequestedContentTypeSupported(requestContext)) {
            totalScore = Math.max(totalScore, this.scoreByContentType(requestContext, MediaType.JSON));
        }
        LOG.debug("Renderer score is {}", (Object)totalScore);
        return totalScore > 0 ? totalScore : 0;
    }
}

