/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.renderer;

import com.sdl.odata.api.parser.FormatOption;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.renderer.AbstractRenderer;
import java.util.List;
import scala.Option;

public abstract class AbstractAtomRenderer
extends AbstractRenderer {
    private static final int DEFAULT_XML_RENDER_SCORE = 31;

    public int score(ODataRequestContext requestContext, Object data) {
        int atomXmlFormatScore = this.scoreByFormat((Option<FormatOption>)ODataUriUtil.getFormatOption((ODataUri)requestContext.getUri()), MediaType.ATOM_XML);
        int xmlFormatScore = this.scoreByFormat((Option<FormatOption>)ODataUriUtil.getFormatOption((ODataUri)requestContext.getUri()), MediaType.XML);
        List accept = requestContext.getRequest().getAccept();
        int atomXmlAcceptScore = this.scoreByMediaType(accept, MediaType.ATOM_XML);
        int xmlAcceptScore = this.scoreByMediaType(accept, MediaType.XML);
        int totalScore = Math.max(atomXmlFormatScore, Math.max(xmlFormatScore, Math.max(atomXmlAcceptScore, xmlAcceptScore)));
        if (this.isRequestedContentTypeSupported(requestContext)) {
            totalScore = Math.max(totalScore, this.scoreByContentType(requestContext, MediaType.ATOM_XML));
        } else if (totalScore == 30 || totalScore == 0) {
            return 31;
        }
        return totalScore > 0 ? totalScore : 0;
    }
}

